/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.util.Utils;

public class PartitionDataWriterContext {
    private final long splitThreshold;
    private final PartitionSplitMode partitionSplitMode;
    private final boolean rangeReadFilter;
    private final PartitionLocation partitionLocation;
    private final String appId;
    private final int shuffleId;
    private final UserIdentifier userIdentifier;
    private final boolean partitionSplitEnabled;
    private final String shuffleKey;
    private final PartitionType partitionType;

    public PartitionDataWriterContext(long splitThreshold, PartitionSplitMode partitionSplitMode, boolean rangeReadFilter, PartitionLocation partitionLocation, String appId, int shuffleId, UserIdentifier userIdentifier, PartitionType partitionType, boolean partitionSplitEnabled) {
        this.splitThreshold = splitThreshold;
        this.partitionSplitMode = partitionSplitMode;
        this.rangeReadFilter = rangeReadFilter;
        this.partitionLocation = partitionLocation;
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.userIdentifier = userIdentifier;
        this.partitionSplitEnabled = partitionSplitEnabled;
        this.partitionType = partitionType;
        this.shuffleKey = Utils.makeShuffleKey((String)appId, (int)shuffleId);
    }

    public long getSplitThreshold() {
        return this.splitThreshold;
    }

    public PartitionSplitMode getPartitionSplitMode() {
        return this.partitionSplitMode;
    }

    public boolean isRangeReadFilter() {
        return this.rangeReadFilter;
    }

    public PartitionLocation getPartitionLocation() {
        return this.partitionLocation;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public UserIdentifier getUserIdentifier() {
        return this.userIdentifier;
    }

    public boolean isPartitionSplitEnabled() {
        return this.partitionSplitEnabled;
    }

    public String getShuffleKey() {
        return this.shuffleKey;
    }

    public PartitionType getPartitionType() {
        return this.partitionType;
    }
}

