/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.ThreadSafeRpcEndpoint;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.NettyRpcCallContext;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.OnStart$;
import org.apache.celeborn.common.rpc.netty.OnStop$;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnected;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnectionError;
import org.apache.celeborn.common.rpc.netty.RemoteProcessDisconnected;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005uf!B\u0001\u0003\u0001!q!!B%oE>D(BA\u0002\u0005\u0003\u0015qW\r\u001e;z\u0015\t)a!A\u0002sa\u000eT!a\u0002\u0005\u0002\r\r|W.\\8o\u0015\tI!\"\u0001\u0005dK2,'m\u001c:o\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0014\u0007\u0001yQ\u0003\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-ei\u0011a\u0006\u0006\u00031\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00035]\u0011q\u0001T8hO&tw\r\u0003\u0005\u001d\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003-)g\u000e\u001a9pS:$(+\u001a4\u0004\u0001U\tq\u0004\u0005\u0002!C5\t!!\u0003\u0002#\u0005\t\u0019b*\u001a;usJ\u00038-\u00128ea>Lg\u000e\u001e*fM\"AA\u0005\u0001B\u0001B\u0003%q$\u0001\u0007f]\u0012\u0004x.\u001b8u%\u00164\u0007\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0001(\u0003!)g\u000e\u001a9pS:$X#\u0001\u0015\u0011\u0005%RS\"\u0001\u0003\n\u0005-\"!a\u0003*qG\u0016sG\r]8j]RD\u0001\"\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\nK:$\u0007o\\5oi\u0002B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001M\u0001\u0005G>tg-F\u00012!\t\u00114'D\u0001\u0007\u0013\t!dA\u0001\u0007DK2,'m\u001c:o\u0007>tg\r\u0003\u00057\u0001\t\u0005\t\u0015!\u00032\u0003\u0015\u0019wN\u001c4!\u0011\u0015A\u0004\u0001\"\u0001:\u0003\u0019a\u0014N\\5u}Q!!h\u000f\u001f>!\t\u0001\u0003\u0001C\u0003\u001do\u0001\u0007q\u0004C\u0003'o\u0001\u0007\u0001\u0006C\u00030o\u0001\u0007\u0011\u0007\u0003\u0005@\u0001\t\u0007I\u0011\u0001\u0002A\u0003!\u0019\u0017\r]1dSRLX#A!\u0011\u0005A\u0011\u0015BA\"\u0012\u0005\rIe\u000e\u001e\u0005\u0007\u000b\u0002\u0001\u000b\u0011B!\u0002\u0013\r\f\u0007/Y2jif\u0004\u0003\u0002C$\u0001\u0005\u0004%\tA\u0001%\u0002\u0013%t'm\u001c=M_\u000e\\W#A%\u0011\u0005)\u001bV\"A&\u000b\u00051k\u0015!\u00027pG.\u001c(B\u0001(P\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003!F\u000bA!\u001e;jY*\t!+\u0001\u0003kCZ\f\u0017B\u0001+L\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\"1a\u000b\u0001Q\u0001\n%\u000b!\"\u001b8c_bdunY6!\u0011!A\u0006A1A\u0005\u0002\tI\u0016AB5t\rVdG.F\u0001[!\tQ5,\u0003\u0002]\u0017\nI1i\u001c8eSRLwN\u001c\u0005\u0007=\u0002\u0001\u000b\u0011\u0002.\u0002\u000f%\u001ch)\u001e7mA!9\u0001\r\u0001b\u0001\n#\t\u0017\u0001C7fgN\fw-Z:\u0016\u0003\t\u00042a\u00193g\u001b\u0005y\u0015BA3P\u0005)a\u0015N\\6fI2K7\u000f\u001e\t\u0003A\u001dL!\u0001\u001b\u0002\u0003\u0019%s'm\u001c=NKN\u001c\u0018mZ3\t\r)\u0004\u0001\u0015!\u0003c\u0003%iWm]:bO\u0016\u001c\b\u0005\u000b\u0003jYV4\bCA7t\u001b\u0005q'B\u0001(p\u0015\t\u0001\u0018/\u0001\u0006b]:|G/\u0019;j_:T\u0011A]\u0001\u0006U\u00064\u0018\r_\u0005\u0003i:\u0014\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0003]\fA\u0001\u001e5jg\"9\u0011\u0010\u0001b\u0001\n\u0013Q\u0018\u0001D7fgN\fw-Z\"pk:$X#A>\u0011\u0005q|X\"A?\u000b\u0005yl\u0015AB1u_6L7-C\u0002\u0002\u0002u\u0014!\"\u0011;p[&\u001cGj\u001c8h\u0011\u001d\t)\u0001\u0001Q\u0001\nm\fQ\"\\3tg\u0006<WmQ8v]R\u0004\u0003\"CA\u0005\u0001\u0001\u0007I\u0011BA\u0006\u0003\u001d\u0019Ho\u001c9qK\u0012,\"!!\u0004\u0011\u0007A\ty!C\u0002\u0002\u0012E\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018\u0005Y1\u000f^8qa\u0016$w\fJ3r)\u0011\tI\"a\b\u0011\u0007A\tY\"C\u0002\u0002\u001eE\u0011A!\u00168ji\"Q\u0011\u0011EA\n\u0003\u0003\u0005\r!!\u0004\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002&\u0001\u0001\u000b\u0015BA\u0007\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003&BA\u0012YV4\b\"CA\u0016\u0001\u0001\u0007I\u0011BA\u0006\u0003A)g.\u00192mK\u000e{gnY;se\u0016tG\u000fC\u0005\u00020\u0001\u0001\r\u0011\"\u0003\u00022\u0005!RM\\1cY\u0016\u001cuN\\2veJ,g\u000e^0%KF$B!!\u0007\u00024!Q\u0011\u0011EA\u0017\u0003\u0003\u0005\r!!\u0004\t\u0011\u0005]\u0002\u0001)Q\u0005\u0003\u001b\t\u0011#\u001a8bE2,7i\u001c8dkJ\u0014XM\u001c;!Q\u0015\t)\u0004\\;w\u0011!\ti\u0004\u0001a\u0001\n\u0013\u0001\u0015\u0001\u00058v[\u0006\u001bG/\u001b<f)\"\u0014X-\u00193t\u0011%\t\t\u0005\u0001a\u0001\n\u0013\t\u0019%\u0001\u000bok6\f5\r^5wKRC'/Z1eg~#S-\u001d\u000b\u0005\u00033\t)\u0005C\u0005\u0002\"\u0005}\u0012\u0011!a\u0001\u0003\"9\u0011\u0011\n\u0001!B\u0013\t\u0015!\u00058v[\u0006\u001bG/\u001b<f)\"\u0014X-\u00193tA!*\u0011q\t7vm\"9\u0011q\n\u0001\u0005\u0002\u0005E\u0013AC1eI6+7o]1hKR!\u0011\u0011DA*\u0011\u001d\t)&!\u0014A\u0002\u0019\fq!\\3tg\u0006<W\rC\u0004\u0002Z\u0001!I!a\u0017\u0002\u001fA\u0014xnY3tg&sG/\u001a:oC2$b!!\u0007\u0002^\u0005\u001d\u0004\u0002CA0\u0003/\u0002\r!!\u0019\u0002\u0015\u0011L7\u000f]1uG\",'\u000fE\u0002!\u0003GJ1!!\u001a\u0003\u0005)!\u0015n\u001d9bi\u000eDWM\u001d\u0005\b\u0003+\n9\u00061\u0001g\u0011!\tY\u0007\u0001C\u0001\u0005\u00055\u0014AC<bSR|eNR;mYR\u0011\u0011\u0011\u0004\u0005\b\u0003c\u0002A\u0011BA7\u00035\u0019\u0018n\u001a8bY:{GOR;mY\"9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0014a\u00029s_\u000e,7o\u001d\u000b\u0005\u00033\tI\b\u0003\u0005\u0002`\u0005M\u0004\u0019AA1\u0011\u001d\ti\b\u0001C\u0001\u0003\u007f\nA\u0001]8tiR!\u0011\u0011DAA\u0011\u001d\t)&a\u001fA\u0002\u0019Dq!!\"\u0001\t\u0003\ti'\u0001\u0003ti>\u0004\bbBAE\u0001\u0011\u0005\u00111B\u0001\bSN,U\u000e\u001d;z\u0011\u001d\ti\t\u0001C\t\u0003\u001f\u000baa\u001c8Ee>\u0004H\u0003BA\r\u0003#Cq!!\u0016\u0002\f\u0002\u0007a\rC\u0004\u0002\u0016\u0002!I!a&\u0002\u0015M\fg-\u001a7z\u0007\u0006dG\u000e\u0006\u0004\u0002\u001a\u0006\u0015\u0016q\u0015\u000b\u0005\u00033\tY\nC\u0005\u0002\u001e\u0006ME\u00111\u0001\u0002 \u00061\u0011m\u0019;j_:\u0004R\u0001EAQ\u00033I1!a)\u0012\u0005!a$-\u001f8b[\u0016t\u0004B\u0002\u0014\u0002\u0014\u0002\u0007\u0001\u0006\u0003\u0005\u0002*\u0006M\u0005\u0019AAV\u0003=)g\u000e\u001a9pS:$(+\u001a4OC6,\u0007\u0003BAW\u0003gs1\u0001EAX\u0013\r\t\t,E\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0016q\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E\u0016\u0003\u0003\u0004\u0002<\u0002!\t\u0001Q\u0001\u0014O\u0016$h*^7BGRLg/\u001a+ie\u0016\fGm\u001d")
public class Inbox
implements Logging {
    private final NettyRpcEndpointRef endpointRef;
    private final RpcEndpoint endpoint;
    private final CelebornConf conf;
    private final int capacity;
    private final ReentrantLock inboxLock;
    private final Condition isFull;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    private final AtomicLong org$apache$celeborn$common$rpc$netty$Inbox$$messageCount;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private final transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        Inbox inbox = this;
        synchronized (inbox) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    public NettyRpcEndpointRef endpointRef() {
        return this.endpointRef;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public CelebornConf conf() {
        return this.conf;
    }

    public int capacity() {
        return this.capacity;
    }

    public ReentrantLock inboxLock() {
        return this.inboxLock;
    }

    public Condition isFull() {
        return this.isFull;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    public AtomicLong org$apache$celeborn$common$rpc$netty$Inbox$$messageCount() {
        return this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void addMessage(InboxMessage message) {
        this.messages().add(message);
        this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().incrementAndGet();
        this.signalNotFull();
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Inbox $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"queue length of ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().get())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void org$apache$celeborn$common$rpc$netty$Inbox$$processInternal(Dispatcher dispatcher, InboxMessage message) {
        InboxMessage inboxMessage = message;
        if (inboxMessage instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)inboxMessage;
            RpcAddress _sender = rpcMessage.senderAddress();
            Object content = rpcMessage.content();
            NettyRpcCallContext context = rpcMessage.context();
            try {
                BoxedUnit boxedUnit2 = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1)new Serializable(this, message, _sender){
                    public static final long serialVersionUID = 0L;
                    private final InboxMessage message$1;
                    private final RpcAddress _sender$1;

                    public final Nothing$ apply(Object msg) {
                        throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported message ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.message$1, this._sender$1})));
                    }
                    {
                        this.message$1 = message$1;
                        this._sender$1 = _sender$1;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                context.sendFailure(throwable);
                throw throwable;
            }
        }
        if (inboxMessage instanceof OneWayMessage) {
            OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
            RpcAddress _sender = oneWayMessage.senderAddress();
            Object content = oneWayMessage.content();
            BoxedUnit boxedUnit3 = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1)new Serializable(this, message, _sender){
                public static final long serialVersionUID = 0L;
                private final InboxMessage message$1;
                private final RpcAddress _sender$2;

                public final Nothing$ apply(Object msg) {
                    throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported message ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.message$1, this._sender$2})));
                }
                {
                    this.message$1 = message$1;
                    this._sender$2 = _sender$2;
                }
            });
            return;
        }
        if (OnStart$.MODULE$.equals(inboxMessage)) {
            BoxedUnit boxedUnit;
            this.endpoint().onStart();
            if (this.endpoint() instanceof ThreadSafeRpcEndpoint) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.inboxLock().lockInterruptibly();
                if (!this.stopped()) {
                    this.enableConcurrent_$eq(true);
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
            return;
        }
        if (OnStop$.MODULE$.equals(inboxMessage)) {
            this.inboxLock().lockInterruptibly();
            int activeThreads = this.numActiveThreads();
            Predef$.MODULE$.assert(activeThreads == 1, (Function0)new Serializable(this, activeThreads){
                public static final long serialVersionUID = 0L;
                private final int activeThreads$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be only a single active thread but found ", " threads."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.activeThreads$1)}));
                }
                {
                    this.activeThreads$1 = activeThreads$1;
                }
            });
            dispatcher.removeRpcEndpointRef(this.endpoint());
            this.endpoint().onStop();
            Predef$.MODULE$.assert(this.isEmpty(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "OnStop should be the last message";
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (inboxMessage instanceof RemoteProcessConnected) {
            RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
            RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
            this.endpoint().onConnected(remoteAddress);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (inboxMessage instanceof RemoteProcessDisconnected) {
            RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
            RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
            this.endpoint().onDisconnected(remoteAddress);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!(inboxMessage instanceof RemoteProcessConnectionError)) throw new MatchError((Object)inboxMessage);
        RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
        Throwable cause = remoteProcessConnectionError.cause();
        RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
        this.endpoint().onNetworkError(cause, remoteAddress);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return;
        finally {
            this.inboxLock().unlock();
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    public void waitOnFull() {
        if (this.capacity() > 0 && !this.stopped()) {
            this.inboxLock().lockInterruptibly();
            while (this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().get() >= (long)this.capacity()) {
                this.isFull().await();
            }
        }
        return;
        finally {
            this.inboxLock().unlock();
        }
    }

    private void signalNotFull() {
        Predef$.MODULE$.require(this.inboxLock().isHeldByCurrentThread(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "cannot call signalNotFull without holding lock";
            }
        });
        if (this.capacity() > 0 && this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().get() < (long)this.capacity()) {
            this.isFull().signal();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(Dispatcher dispatcher) {
        ObjectRef message = ObjectRef.create(null);
        try {
            this.inboxLock().lockInterruptibly();
            if (!this.enableConcurrent() && this.numActiveThreads() != 0) {
                return;
            }
            message.elem = this.messages().poll();
            if ((InboxMessage)message.elem == null) {
                return;
            }
            this.numActiveThreads_$eq(this.numActiveThreads() + 1);
            this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().decrementAndGet();
            this.signalNotFull();
        }
        finally {
            this.inboxLock().unlock();
        }
        while (true) {
            this.safelyCall(this.endpoint(), this.endpointRef().name(), (Function0<BoxedUnit>)new Serializable(this, dispatcher, message){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Inbox $outer;
                private final Dispatcher dispatcher$1;
                private final ObjectRef message$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.org$apache$celeborn$common$rpc$netty$Inbox$$processInternal(this.dispatcher$1, (InboxMessage)this.message$2.elem);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dispatcher$1 = dispatcher$1;
                    this.message$2 = message$2;
                }
            });
            try {
                this.inboxLock().lockInterruptibly();
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    return;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    return;
                }
                this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().decrementAndGet();
                this.signalNotFull();
                continue;
            }
            finally {
                this.inboxLock().unlock();
                continue;
            }
            break;
        }
    }

    public void post(InboxMessage message) {
        try {
            this.inboxLock().lockInterruptibly();
            if (this.stopped()) {
                this.onDrop(message);
            } else {
                this.addMessage(message);
            }
            return;
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    public void stop() {
        try {
            this.inboxLock().lockInterruptibly();
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                this.addMessage(OnStop$.MODULE$);
            }
            return;
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    public boolean isEmpty() {
        try {
            this.inboxLock().lockInterruptibly();
            return this.messages().isEmpty();
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    public void onDrop(InboxMessage message) {
        this.logWarning((Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Inbox $outer;
            private final InboxMessage message$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Drop ", " because ", " is stopped"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.message$3, this.$outer.endpointRef()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.message$3 = message$3;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void safelyCall(RpcEndpoint endpoint, String endpointRefName, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
            return;
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                this.dealWithFatalError$1(throwable3, endpointRefName);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
            Throwable e = (Throwable)option.get();
            try {
                endpoint.onError(e);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable4) {
                Throwable throwable5 = throwable4;
                Option option2 = NonFatal$.MODULE$.unapply(throwable5);
                if (option2.isEmpty()) {
                    if (throwable5 == null) throw throwable4;
                    Throwable throwable6 = throwable5;
                    this.dealWithFatalError$1(throwable6, endpointRefName);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit4;
                    Throwable ee = (Throwable)option2.get();
                    if (this.stopped()) {
                        this.logDebug((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Ignoring error";
                            }
                        }, ee);
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        this.logError((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Ignoring error";
                            }
                        }, ee);
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit5 = boxedUnit4;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        }
    }

    public int getNumActiveThreads() {
        try {
            this.inboxLock().lockInterruptibly();
            return this.numActiveThreads();
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    private final void dealWithFatalError$1(Throwable fatal, String endpointRefName$1) {
        this.inboxLock().lockInterruptibly();
        Predef$.MODULE$.assert(this.numActiveThreads() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The number of active threads should be positive.";
            }
        });
        this.numActiveThreads_$eq(this.numActiveThreads() - 1);
        this.logError((Function0<String>)new Serializable(this, endpointRefName$1){
            public static final long serialVersionUID = 0L;
            private final String endpointRefName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"An error happened while processing message in the inbox for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.endpointRefName$1}));
            }
            {
                this.endpointRefName$1 = endpointRefName$1;
            }
        }, fatal);
        throw fatal;
        finally {
            this.inboxLock().unlock();
        }
    }

    public Inbox(NettyRpcEndpointRef endpointRef, RpcEndpoint endpoint, CelebornConf conf) {
        this.endpointRef = endpointRef;
        this.endpoint = endpoint;
        this.conf = conf;
        Logging$class.$init$(this);
        this.capacity = BoxesRunTime.unboxToInt((Object)conf.get(CelebornConf$.MODULE$.RPC_INBOX_CAPACITY()));
        this.inboxLock = new ReentrantLock();
        this.isFull = this.inboxLock().newCondition();
        this.messages = new LinkedList();
        this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount = new AtomicLong(0L);
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        try {
            this.inboxLock().lockInterruptibly();
            this.messages().add(OnStart$.MODULE$);
            this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().incrementAndGet();
            return;
        }
        finally {
            this.inboxLock().unlock();
        }
    }
}

