/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.protocol.ShuffleMode;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.DeterministicLevel;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.celeborn.CelebornShuffleFallbackPolicyRunner;
import org.apache.spark.shuffle.celeborn.CelebornShuffleHandle;
import org.apache.spark.shuffle.celeborn.CelebornShuffleReader;
import org.apache.spark.shuffle.celeborn.ExecutorShuffleIdTracker;
import org.apache.spark.shuffle.celeborn.HashBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.SendBufferPool;
import org.apache.spark.shuffle.celeborn.SortBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.SparkCommonUtils;
import org.apache.spark.shuffle.celeborn.SparkUtils;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Int;

public class SparkShuffleManager
implements ShuffleManager {
    private static final Logger logger = LoggerFactory.getLogger(SparkShuffleManager.class);
    private static final String sortShuffleManagerName = "org.apache.spark.shuffle.sort.SortShuffleManager";
    private final SparkConf conf;
    private final Boolean isDriver;
    private final CelebornConf celebornConf;
    private final int cores;
    private String appUniqueId;
    private LifecycleManager lifecycleManager;
    private ShuffleClient shuffleClient;
    private volatile SortShuffleManager _sortShuffleManager;
    private final ConcurrentHashMap.KeySetView<Integer, Boolean> sortShuffleIds = ConcurrentHashMap.newKeySet();
    private final CelebornShuffleFallbackPolicyRunner fallbackPolicyRunner;
    private long sendBufferPoolCheckInterval;
    private long sendBufferPoolExpireTimeout;
    private ExecutorShuffleIdTracker shuffleIdTracker = new ExecutorShuffleIdTracker();

    public SparkShuffleManager(SparkConf conf, boolean isDriver) {
        SparkCommonUtils.validateAttemptConfig(conf);
        this.conf = conf;
        this.isDriver = isDriver;
        this.celebornConf = SparkUtils.fromSparkConf(conf);
        this.cores = conf.getInt("spark.executor.cores", 1);
        this.fallbackPolicyRunner = new CelebornShuffleFallbackPolicyRunner(this.celebornConf);
        this.sendBufferPoolCheckInterval = this.celebornConf.clientPushSendBufferPoolExpireCheckInterval();
        this.sendBufferPoolExpireTimeout = this.celebornConf.clientPushSendBufferPoolExpireTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortShuffleManager sortShuffleManager() {
        if (this._sortShuffleManager == null) {
            SparkShuffleManager sparkShuffleManager = this;
            synchronized (sparkShuffleManager) {
                if (this._sortShuffleManager == null) {
                    this._sortShuffleManager = (SortShuffleManager)SparkUtils.instantiateClass(sortShuffleManagerName, this.conf, this.isDriver);
                }
            }
        }
        return this._sortShuffleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLifecycleManager(String appId) {
        if (this.isDriver.booleanValue() && this.lifecycleManager == null) {
            SparkShuffleManager sparkShuffleManager = this;
            synchronized (sparkShuffleManager) {
                if (this.lifecycleManager == null) {
                    this.lifecycleManager = new LifecycleManager(appId, this.celebornConf);
                    if (this.celebornConf.clientFetchThrowsFetchFailure()) {
                        MapOutputTrackerMaster mapOutputTracker = (MapOutputTrackerMaster)SparkEnv.get().mapOutputTracker();
                        this.lifecycleManager.registerShuffleTrackerCallback(shuffleId -> mapOutputTracker.unregisterAllMapOutput(shuffleId.intValue()));
                    }
                }
            }
        }
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, int numMaps, ShuffleDependency<K, V, C> dependency) {
        this.appUniqueId = SparkUtils.appUniqueId(dependency.rdd().context());
        this.initializeLifecycleManager(this.appUniqueId);
        this.lifecycleManager.registerAppShuffleDeterminate(shuffleId, dependency.rdd().getOutputDeterministicLevel() != DeterministicLevel.INDETERMINATE());
        if (this.fallbackPolicyRunner.applyAllFallbackPolicy(this.lifecycleManager, dependency.partitioner().numPartitions())) {
            logger.warn("Fallback to SortShuffleManager!");
            this.sortShuffleIds.add(shuffleId);
            return this.sortShuffleManager().registerShuffle(shuffleId, numMaps, dependency);
        }
        return new CelebornShuffleHandle<K, V, C>(this.appUniqueId, this.lifecycleManager.getHost(), this.lifecycleManager.getPort(), this.lifecycleManager.getUserIdentifier(), shuffleId, this.celebornConf.clientFetchThrowsFetchFailure(), numMaps, dependency);
    }

    public boolean unregisterShuffle(int appShuffleId) {
        if (this.sortShuffleIds.contains(appShuffleId)) {
            return this.sortShuffleManager().unregisterShuffle(appShuffleId);
        }
        if (this.lifecycleManager != null) {
            this.lifecycleManager.unregisterAppShuffle(appShuffleId, this.celebornConf.clientFetchThrowsFetchFailure());
        }
        if (this.shuffleClient != null) {
            this.shuffleIdTracker.unregisterAppShuffleId(this.shuffleClient, appShuffleId);
        }
        return true;
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        return this.sortShuffleManager().shuffleBlockResolver();
    }

    public void stop() {
        if (this.shuffleClient != null) {
            this.shuffleClient.shutdown();
            ShuffleClient.reset();
            this.shuffleClient = null;
        }
        if (this.lifecycleManager != null) {
            this.lifecycleManager.stop();
            this.lifecycleManager = null;
        }
        if (this._sortShuffleManager != null) {
            this._sortShuffleManager.stop();
            this._sortShuffleManager = null;
        }
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, int mapId, TaskContext context) {
        try {
            if (handle instanceof CelebornShuffleHandle) {
                CelebornShuffleHandle h = (CelebornShuffleHandle)handle;
                ShuffleClient client = ShuffleClient.get(h.appUniqueId(), h.lifecycleManagerHost(), h.lifecycleManagerPort(), this.celebornConf, h.userIdentifier(), h.extension());
                int shuffleId = SparkUtils.celebornShuffleId(client, h, context, true);
                this.shuffleIdTracker.track(h.shuffleId(), shuffleId);
                if (ShuffleMode.SORT.equals((Object)this.celebornConf.shuffleWriterMode())) {
                    return new SortBasedShuffleWriter(shuffleId, h.dependency(), h.numMaps(), context, this.celebornConf, client, SendBufferPool.get(this.cores, this.sendBufferPoolCheckInterval, this.sendBufferPoolExpireTimeout));
                }
                if (ShuffleMode.HASH.equals((Object)this.celebornConf.shuffleWriterMode())) {
                    return new HashBasedShuffleWriter(shuffleId, h, mapId, context, this.celebornConf, client, SendBufferPool.get(this.cores, this.sendBufferPoolCheckInterval, this.sendBufferPoolExpireTimeout));
                }
                throw new UnsupportedOperationException("Unrecognized shuffle write mode!" + (Object)((Object)this.celebornConf.shuffleWriterMode()));
            }
            this.sortShuffleIds.add(handle.shuffleId());
            return this.sortShuffleManager().getWriter(handle, mapId, context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context) {
        if (handle instanceof CelebornShuffleHandle) {
            CelebornShuffleHandle h = (CelebornShuffleHandle)handle;
            return new CelebornShuffleReader(h, startPartition, endPartition, 0, Int.MaxValue(), context, this.celebornConf, this.shuffleIdTracker);
        }
        return this._sortShuffleManager.getReader(handle, startPartition, endPartition, context);
    }

    private int executorCores(SparkConf conf) {
        if (Utils.isLocalMaster((SparkConf)conf)) {
            return (Integer)DynMethods.builder("numDriverCores").impl("org.apache.spark.SparkContext$", String.class).build().bind(SparkContext$.MODULE$).invoke(conf.get("spark.master"));
        }
        return conf.getInt("spark.executor.cores", 1);
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }
}

