/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.AlreadyClosedException;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.unsafe.Platform;
import org.apache.celeborn.common.util.FileChannelUtils;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.congestcontrol.CongestionController;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.apache.celeborn.service.deploy.worker.storage.FlushNotifier;
import org.apache.celeborn.service.deploy.worker.storage.FlushTask;
import org.apache.celeborn.service.deploy.worker.storage.Flusher;
import org.apache.celeborn.service.deploy.worker.storage.HdfsFlushTask;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlushTask;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlusher;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileWriter
implements DeviceObserver {
    private static final Logger logger = LoggerFactory.getLogger(FileWriter.class);
    private static final long WAIT_INTERVAL_MS = 5L;
    protected final FileInfo fileInfo;
    private FileChannel channel;
    private volatile boolean closed;
    private volatile boolean destroyed;
    protected final AtomicInteger numPendingWrites = new AtomicInteger();
    public final Flusher flusher;
    private final int flushWorkerIndex;
    @GuardedBy(value="flushLock")
    private CompositeByteBuf flushBuffer;
    private final Object flushLock = new Object();
    private final long writerCloseTimeoutMs;
    protected final long flusherBufferSize;
    protected final DeviceMonitor deviceMonitor;
    protected final AbstractSource source;
    private long splitThreshold = 0L;
    private final PartitionSplitMode splitMode;
    private final PartitionType partitionType;
    private final boolean rangeReadFilter;
    protected boolean deleted = false;
    private RoaringBitmap mapIdBitMap = null;
    protected final FlushNotifier notifier = new FlushNotifier();
    private String shuffleKey;
    private StorageManager storageManager;
    private boolean workerGracefulShutdown;

    public FileWriter(FileInfo fileInfo, Flusher flusher, AbstractSource workerSource, CelebornConf conf, DeviceMonitor deviceMonitor, long splitThreshold, PartitionSplitMode splitMode, PartitionType partitionType, boolean rangeReadFilter) throws IOException {
        this.fileInfo = fileInfo;
        this.flusher = flusher;
        this.flushWorkerIndex = flusher.getWorkerIndex();
        this.writerCloseTimeoutMs = conf.workerWriterCloseTimeoutMs();
        this.workerGracefulShutdown = conf.workerGracefulShutdown();
        this.splitThreshold = splitThreshold;
        this.deviceMonitor = deviceMonitor;
        this.splitMode = splitMode;
        this.partitionType = partitionType;
        this.rangeReadFilter = rangeReadFilter;
        if (!fileInfo.isHdfs()) {
            this.flusherBufferSize = conf.workerFlusherBufferSize();
            this.channel = FileChannelUtils.createWritableFileChannel((String)fileInfo.getFilePath());
        } else {
            this.flusherBufferSize = conf.workerHdfsFlusherBufferSize();
            try {
                StorageManager.hadoopFs().create(fileInfo.getHdfsPath(), true).close();
            }
            catch (IOException e) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                StorageManager.hadoopFs().create(fileInfo.getHdfsPath(), true).close();
            }
        }
        this.source = workerSource;
        logger.debug("FileWriter {} split threshold {} mode {}", new Object[]{this, splitThreshold, splitMode});
        if (rangeReadFilter) {
            this.mapIdBitMap = new RoaringBitmap();
        }
        this.takeBuffer();
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public File getFile() {
        return this.fileInfo.getFile();
    }

    public void incrementPendingWrites() {
        this.numPendingWrites.incrementAndGet();
    }

    public void decrementPendingWrites() {
        this.numPendingWrites.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(boolean finalFlush) throws IOException {
        Object object = this.flushLock;
        synchronized (object) {
            int numBytes;
            if (this.flushBuffer != null && (numBytes = this.flushBuffer.readableBytes()) != 0) {
                this.notifier.checkException();
                this.notifier.numPendingFlushes.incrementAndGet();
                FlushTask task = null;
                if (this.channel != null) {
                    task = new LocalFlushTask(this.flushBuffer, this.channel, this.notifier);
                } else if (this.fileInfo.isHdfs()) {
                    task = new HdfsFlushTask(this.flushBuffer, this.fileInfo.getHdfsPath(), this.notifier);
                }
                this.addTask(task);
                this.flushBuffer = null;
                this.fileInfo.updateBytesFlushed((long)numBytes);
                if (!finalFlush) {
                    this.takeBuffer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuf data) throws IOException {
        if (this.closed) {
            String msg = "FileWriter has already closed!, fileName " + this.fileInfo.getFilePath();
            logger.warn(msg);
            throw new AlreadyClosedException(msg);
        }
        if (this.notifier.hasException()) {
            return;
        }
        int mapId = 0;
        if (this.rangeReadFilter) {
            byte[] header = new byte[4];
            data.markReaderIndex();
            data.readBytes(header);
            data.resetReaderIndex();
            mapId = Platform.getInt((Object)header, (long)Platform.BYTE_ARRAY_OFFSET);
        }
        int numBytes = data.readableBytes();
        MemoryManager.instance().incrementDiskBuffer(numBytes);
        Optional.ofNullable(CongestionController.instance()).ifPresent(congestionController -> congestionController.produceBytes(this.fileInfo.getUserIdentifier(), numBytes));
        Object object = this.flushLock;
        synchronized (object) {
            if (this.closed) {
                String msg = "FileWriter has already closed!, fileName " + this.fileInfo.getFilePath();
                logger.warn(msg);
                throw new AlreadyClosedException(msg);
            }
            if (this.rangeReadFilter) {
                this.mapIdBitMap.add(mapId);
            }
            if (this.flushBuffer.readableBytes() != 0 && (long)(this.flushBuffer.readableBytes() + numBytes) >= this.flusherBufferSize) {
                this.flush(false);
            }
            data.retain();
            this.flushBuffer.addComponent(true, data);
        }
        this.numPendingWrites.decrementAndGet();
    }

    public RoaringBitmap getMapIdBitMap() {
        return this.mapIdBitMap;
    }

    public StorageInfo getStorageInfo() {
        if (this.flusher instanceof LocalFlusher) {
            LocalFlusher localFlusher = (LocalFlusher)this.flusher;
            return new StorageInfo(localFlusher.diskType(), true, "");
        }
        if (this.deleted) {
            return null;
        }
        return new StorageInfo(StorageInfo.Type.HDFS, true, this.fileInfo.getFilePath());
    }

    public abstract long close() throws IOException;

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long close(RunnableWithIOException tryClose, RunnableWithIOException streamClose, RunnableWithIOException finalClose) throws IOException {
        if (this.closed) {
            String msg = "FileWriter has already closed! fileName " + this.fileInfo.getFilePath();
            logger.error(msg);
            throw new AlreadyClosedException(msg);
        }
        try {
            this.waitOnNoPending(this.numPendingWrites);
            this.closed = true;
            Object msg = this.flushLock;
            synchronized (msg) {
                if (this.flushBuffer.readableBytes() > 0) {
                    this.flush(true);
                }
            }
            tryClose.run();
            this.waitOnNoPending(this.notifier.numPendingFlushes);
        }
        finally {
            this.returnBuffer();
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
                streamClose.run();
            }
            catch (IOException e) {
                logger.warn("close file writer {} failed", (Object)this, (Object)e);
            }
            finalClose.run();
            if (!this.fileInfo.isHdfs()) {
                logger.debug("file info {} unregister from device monitor", (Object)this.fileInfo);
                this.deviceMonitor.unregisterFileWriter(this);
            }
        }
        if (this.workerGracefulShutdown) {
            this.storageManager.notifyFileInfoCommitted(this.shuffleKey, this.getFile().getName(), this.fileInfo);
        }
        return this.fileInfo.getFileLength();
    }

    public synchronized void destroy(IOException ioException) {
        if (!this.closed) {
            this.closed = true;
            if (!this.notifier.hasException()) {
                this.notifier.setException(ioException);
            }
            this.returnBuffer();
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException e) {
                logger.warn("Close channel failed for file {} caused by {}.", (Object)this.fileInfo.getFilePath(), (Object)e.getMessage());
            }
        }
        if (!this.destroyed) {
            this.destroyed = true;
            this.fileInfo.deleteAllFiles(StorageManager.hadoopFs());
            if (!this.fileInfo.isHdfs()) {
                this.deviceMonitor.unregisterFileWriter(this);
            }
        }
    }

    public IOException getException() {
        if (this.notifier.hasException()) {
            return this.notifier.exception.get();
        }
        return null;
    }

    protected void waitOnNoPending(AtomicInteger counter) throws IOException {
        for (long waitTime = this.writerCloseTimeoutMs; counter.get() > 0 && waitTime > 0L; waitTime -= 5L) {
            try {
                this.notifier.checkException();
                TimeUnit.MILLISECONDS.sleep(5L);
                continue;
            }
            catch (InterruptedException e) {
                IOException ioe = new IOException(e);
                this.notifier.setException(ioe);
                throw ioe;
            }
        }
        if (counter.get() > 0) {
            IOException ioe = new IOException("Wait pending actions timeout.");
            this.notifier.setException(ioe);
            throw ioe;
        }
        this.notifier.checkException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void takeBuffer() {
        if (this.source.metricsCollectCriticalEnabled()) {
            String metricsName = WorkerSource.TAKE_BUFFER_TIME();
            String fileAbsPath = this.fileInfo.getFilePath();
            this.source.startTimer(metricsName, fileAbsPath);
            Object object = this.flushLock;
            synchronized (object) {
                this.flushBuffer = this.flusher.takeBuffer();
            }
            this.source.stopTimer(metricsName, fileAbsPath);
        } else {
            Object object = this.flushLock;
            synchronized (object) {
                this.flushBuffer = this.flusher.takeBuffer();
            }
        }
    }

    protected void addTask(FlushTask task) throws IOException {
        if (!this.flusher.addTask(task, this.writerCloseTimeoutMs, this.flushWorkerIndex)) {
            IOException e = new IOException("Add flush task timeout.");
            this.notifier.setException(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnBuffer() {
        Object object = this.flushLock;
        synchronized (object) {
            if (this.flushBuffer != null) {
                this.flusher.returnBuffer(this.flushBuffer);
                this.flushBuffer = null;
            }
        }
    }

    public int hashCode() {
        return this.fileInfo.getFilePath().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FileWriter && this.fileInfo.getFilePath().equals(((FileWriter)obj).fileInfo.getFilePath());
    }

    public String toString() {
        return this.fileInfo.getFilePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOnMemoryPressure() throws IOException {
        Object object = this.flushLock;
        synchronized (object) {
            this.flush(false);
        }
    }

    public long getSplitThreshold() {
        return this.splitThreshold;
    }

    public PartitionSplitMode getSplitMode() {
        return this.splitMode;
    }

    @Override
    public void notifyError(String mountPoint, DiskStatus diskStatus) {
        this.destroy(new IOException("Destroy FileWriter " + this + " by device ERROR. Disk: " + mountPoint + " Status: " + diskStatus));
    }

    @Override
    public void notifyHealthy(String mountPoint) {
    }

    @Override
    public void notifyHighDiskUsage(String mountPoint) {
    }

    @Override
    public void notifyNonCriticalError(String mountPoint, DiskStatus diskStatus) {
    }

    public PartitionType getPartitionType() {
        return this.partitionType;
    }

    public void setShuffleKey(String shuffleKey) {
        this.shuffleKey = shuffleKey;
    }

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @FunctionalInterface
    public static interface RunnableWithIOException {
        public void run() throws IOException;
    }
}

