/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.celeborn.common.CelebornConf;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;

public class FlinkUtils {
    private static final JobID ZERO_JOB_ID = new JobID(0L, 0L);
    public static final Set<String> pluginConfNames = new HashSet<String>(){
        {
            this.add("remote-shuffle.job.min.memory-per-partition");
            this.add("remote-shuffle.job.min.memory-per-gate");
            this.add("remote-shuffle.job.concurrent-readings-per-gate");
            this.add("remote-shuffle.job.memory-per-partition");
            this.add("remote-shuffle.job.memory-per-gate");
            this.add("remote-shuffle.job.support-floating-buffer-per-input-gate");
            this.add("remote-shuffle.job.enable-data-compression");
            this.add("remote-shuffle.job.support-floating-buffer-per-output-gate");
            this.add("remote-shuffle.job.compression.codec");
        }
    };

    public static CelebornConf toCelebornConf(Configuration configuration) {
        CelebornConf tmpCelebornConf = new CelebornConf();
        Map confMap = configuration.toMap();
        for (Map.Entry entry : confMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("celeborn.") && !pluginConfNames.contains(key)) continue;
            tmpCelebornConf.set(key, (String)entry.getValue());
        }
        return tmpCelebornConf;
    }

    public static String toCelebornAppId(long lifecycleManagerTimestamp, JobID jobID) {
        if (!ZERO_JOB_ID.equals((Object)jobID)) {
            return lifecycleManagerTimestamp + "-" + jobID.toString();
        }
        return lifecycleManagerTimestamp + "-" + JobID.generate();
    }

    public static String toShuffleId(JobID jobID, IntermediateDataSetID dataSetID) {
        return jobID.toString() + "-" + dataSetID.toString();
    }

    public static String toAttemptId(ExecutionAttemptID attemptID) {
        return attemptID.toString();
    }
}

