/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.server.common.service.config.ConfigLevel;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.SystemConfig;
import org.apache.celeborn.server.common.service.config.TenantConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import scala.concurrent.duration.Duration;

public class FsConfigServiceImpl
implements ConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(FsConfigServiceImpl.class);
    private final CelebornConf celebornConf;
    private final AtomicReference<SystemConfig> systemConfigAtomicReference = new AtomicReference();
    private final AtomicReference<Map<String, TenantConfig>> tenantConfigAtomicReference = new AtomicReference(new HashMap());
    private static final String CONF_TENANT_ID = "tenantId";
    private static final String CONF_LEVEL = "level";
    private static final String CONF_CONFIG = "config";
    private final ScheduledExecutorService configRefreshService = ThreadUtils.newDaemonSingleThreadScheduledExecutor((String)"celeborn-config-refresher");

    public FsConfigServiceImpl(CelebornConf celebornConf) {
        this.celebornConf = celebornConf;
        this.systemConfigAtomicReference.set(new SystemConfig(celebornConf));
        this.refresh();
        long dynamicConfigRefreshTime = celebornConf.dynamicConfigRefreshInterval();
        this.configRefreshService.scheduleWithFixedDelay(this::refresh, dynamicConfigRefreshTime, dynamicConfigRefreshTime, TimeUnit.MILLISECONDS);
    }

    private synchronized void refresh() {
        File configurationFile = this.getConfigurationFile(System.getenv());
        if (!configurationFile.exists()) {
            return;
        }
        SystemConfig systemConfig = null;
        HashMap<String, TenantConfig> tenantConfs = new HashMap<String, TenantConfig>();
        try (FileInputStream fileInputStream = new FileInputStream(configurationFile);){
            Yaml yaml = new Yaml();
            List dynamicConfigs = (List)yaml.load((InputStream)fileInputStream);
            for (Map settings : dynamicConfigs) {
                String tenantId = (String)settings.get(CONF_TENANT_ID);
                String level = (String)settings.get(CONF_LEVEL);
                Map<String, String> config = ((Map)settings.get(CONF_CONFIG)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, a -> a.getValue().toString()));
                if (ConfigLevel.TENANT.name().equals(level)) {
                    TenantConfig tenantConfig = new TenantConfig(this, tenantId, config);
                    tenantConfs.put(tenantId, tenantConfig);
                    continue;
                }
                systemConfig = new SystemConfig(this.celebornConf, config);
            }
        }
        catch (Exception e) {
            LOG.warn("Refresh dynamic config error: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        this.tenantConfigAtomicReference.set(tenantConfs);
        if (systemConfig != null) {
            this.systemConfigAtomicReference.set(systemConfig);
        }
    }

    @Override
    public SystemConfig getSystemConfig() {
        return this.systemConfigAtomicReference.get();
    }

    @Override
    public TenantConfig getRawTenantConfig(String tenantId) {
        return this.tenantConfigAtomicReference.get().get(tenantId);
    }

    @Override
    public void refreshAllCache() {
        this.refresh();
    }

    @Override
    public void shutdown() {
        ThreadUtils.shutdown((ExecutorService)this.configRefreshService, (Duration)Duration.apply((String)"800ms"));
    }

    private File getConfigurationFile(Map<String, String> env) {
        if (!this.celebornConf.quotaConfigurationPath().isEmpty()) {
            return new File((String)this.celebornConf.quotaConfigurationPath().get());
        }
        String dynamicConfPath = Optional.ofNullable(env.get("CELEBORN_CONF_DIR")).orElse(env.getOrDefault("CELEBORN_HOME", ".") + File.separator + "conf");
        return new File(dynamicConfPath + File.separator + "dynamicConfig.yaml");
    }
}

