/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.command;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ratis.shell.cli.Command;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;

public abstract class AbstractParentCommand
extends AbstractRatisCommand {
    private final Map<String, Command> subs;

    public AbstractParentCommand(Context context, List<Function<Context, AbstractRatisCommand>> subCommandConstructors) {
        super(context);
        this.subs = Collections.unmodifiableMap(subCommandConstructors.stream().map(constructor -> (AbstractRatisCommand)constructor.apply(context)).collect(Collectors.toMap(Command::getCommandName, Function.identity(), (a, b) -> {
            throw new IllegalStateException("Found duplicated commands: " + a + " and " + b);
        }, LinkedHashMap::new)));
    }

    @Override
    public final Map<String, Command> getSubCommands() {
        return this.subs;
    }

    @Override
    public final String getUsage() {
        StringBuilder usage = new StringBuilder(this.getCommandName());
        for (String cmd : this.getSubCommands().keySet()) {
            usage.append(" [").append(cmd).append("]");
        }
        return usage.toString();
    }
}

