/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.util.Quantile;
import org.apache.hadoop.metrics2.util.QuantileEstimator;
import org.apache.hadoop.metrics2.util.SampleQuantiles;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableQuantiles
extends MutableMetric {
    @VisibleForTesting
    public static final Quantile[] quantiles = new Quantile[]{new Quantile(0.5, 0.05), new Quantile(0.75, 0.025), new Quantile(0.9, 0.01), new Quantile(0.95, 0.005), new Quantile(0.99, 0.001)};
    private final MetricsInfo numInfo;
    private final MetricsInfo[] quantileInfos;
    private final int interval;
    private QuantileEstimator estimator;
    private long previousCount = 0L;
    private ScheduledFuture<?> scheduledTask = null;
    @VisibleForTesting
    protected Map<Quantile, Long> previousSnapshot = null;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MutableQuantiles-%d").build());

    public MutableQuantiles(String name, String description, String sampleName, String valueName, int interval) {
        String ucName = StringUtils.capitalize((String)name);
        String usName = StringUtils.capitalize((String)sampleName);
        String uvName = StringUtils.capitalize((String)valueName);
        String desc = StringUtils.uncapitalize((String)description);
        String lsName = StringUtils.uncapitalize((String)sampleName);
        String lvName = StringUtils.uncapitalize((String)valueName);
        this.numInfo = Interns.info(ucName + "Num" + usName, String.format("Number of %s for %s with %ds interval", lsName, desc, interval));
        this.quantileInfos = new MetricsInfo[quantiles.length];
        String nameTemplate = ucName + "%dthPercentile" + uvName;
        String descTemplate = "%d percentile " + lvName + " with " + interval + " second interval for " + desc;
        for (int i = 0; i < quantiles.length; ++i) {
            int percentile = (int)(100.0 * MutableQuantiles.quantiles[i].quantile);
            this.quantileInfos[i] = Interns.info(String.format(nameTemplate, percentile), String.format(descTemplate, percentile));
        }
        this.estimator = new SampleQuantiles(quantiles);
        this.interval = interval;
        this.scheduledTask = scheduler.scheduleWithFixedDelay(new RolloverSample(this), interval, interval, TimeUnit.SECONDS);
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addGauge(this.numInfo, this.previousCount);
            for (int i = 0; i < quantiles.length; ++i) {
                long newValue = 0L;
                if (this.previousSnapshot != null) {
                    newValue = this.previousSnapshot.get(quantiles[i]);
                }
                builder.addGauge(this.quantileInfos[i], newValue);
            }
            if (this.changed()) {
                this.clearChanged();
            }
        }
    }

    public synchronized void add(long value) {
        this.estimator.insert(value);
    }

    public int getInterval() {
        return this.interval;
    }

    public void stop() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
        }
        this.scheduledTask = null;
    }

    @VisibleForTesting
    public synchronized QuantileEstimator getEstimator() {
        return this.estimator;
    }

    public synchronized void setEstimator(QuantileEstimator quantileEstimator) {
        this.estimator = quantileEstimator;
    }

    private static class RolloverSample
    implements Runnable {
        MutableQuantiles parent;

        public RolloverSample(MutableQuantiles parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MutableQuantiles mutableQuantiles = this.parent;
            synchronized (mutableQuantiles) {
                this.parent.previousCount = this.parent.estimator.getCount();
                this.parent.previousSnapshot = this.parent.estimator.snapshot();
                this.parent.estimator.clear();
            }
            this.parent.setChanged();
        }
    }
}

