/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.MetricsConfig;
import org.apache.celeborn.common.metrics.MetricsSystem$;
import org.apache.celeborn.common.metrics.sink.PrometheusHttpRequestHandler;
import org.apache.celeborn.common.metrics.sink.PrometheusServlet;
import org.apache.celeborn.common.metrics.sink.Sink;
import org.apache.celeborn.common.metrics.source.Source;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001\u0002\u00192\u0001qB\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t-\u0002\u0011\t\u0011)A\u0005\u0017\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005]\u0001\t\u0015\r\u0011\"\u0001K\u0011!i\u0006A!A!\u0002\u0013Y\u0005\"\u00020\u0001\t\u0003y\u0006BB3\u0001A\u0003%a\rC\u0004j\u0001\t\u0007I\u0011\u00026\t\re\u0004\u0001\u0015!\u0003l\u0011\u001dQ\bA1A\u0005\nmDq!!\u0007\u0001A\u0003%A\u0010C\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0003\u0002\u001e!A\u0011\u0011\u0007\u0001!\u0002\u0013\ty\u0002C\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u00026!I\u00111\t\u0001A\u0002\u0013%\u0011Q\t\u0005\t\u0003#\u0002\u0001\u0015)\u0003\u00028!I\u00111\u000b\u0001A\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003;\u0002\u0001\u0019!C\u0001\u0003?B\u0001\"a\u0019\u0001A\u0003&\u0011q\u000b\u0005\b\u0003K\u0002A\u0011AA4\u0011\u001d\ty\u0007\u0001C\u0001\u0003cB\u0011\"a\u001e\u0001#\u0003%\t!!\u001f\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u00111\u0013\u0001\u0005\u0002\u0005E\u0005bBAK\u0001\u0011%\u0011q\u0013\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!a/\u0001\t\u0003\ti\fC\u0004\u0002B\u0002!I!!%\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002\u0012\u001e9\u0011QY\u0019\t\u0002\u0005\u001dgA\u0002\u00192\u0011\u0003\tI\r\u0003\u0004_A\u0011\u0005\u00111\u001a\u0005\n\u0003\u001b\u0004#\u0019!C\u0001\u0003\u001fD\u0001\"a8!A\u0003%\u0011\u0011\u001b\u0005\n\u0003C\u0004#\u0019!C\u0001\u0003\u001fD\u0001\"a9!A\u0003%\u0011\u0011\u001b\u0005\n\u0003K\u0004#\u0019!C\u0001\u0003OD\u0001\"a=!A\u0003%\u0011\u0011\u001e\u0005\n\u0003k\u0004#\u0019!C\u0001\u0003OD\u0001\"a>!A\u0003%\u0011\u0011\u001e\u0005\n\u0003s\u0004#\u0019!C\u0001\u0003OD\u0001\"a?!A\u0003%\u0011\u0011\u001e\u0005\t\u0003{\u0004\u0003\u0015!\u0003\u0002\u0000\"A!Q\u0001\u0011!\u0002\u0013\u00119\u0001C\u0004\u0003\u000e\u0001\"\tAa\u0004\t\u000f\te\u0001\u0005\"\u0001\u0003\u001c\tiQ*\u001a;sS\u000e\u001c8+_:uK6T!AM\u001a\u0002\u000f5,GO]5dg*\u0011A'N\u0001\u0007G>lWn\u001c8\u000b\u0005Y:\u0014\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\u0002\u0001'\r\u0001Qh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019\u001b\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005!+%a\u0002'pO\u001eLgnZ\u0001\tS:\u001cH/\u00198dKV\t1\n\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001d~j\u0011a\u0014\u0006\u0003!n\na\u0001\u0010:p_Rt\u0014B\u0001*@\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I{\u0014!C5ogR\fgnY3!\u0003\u0011\u0019wN\u001c4\u0011\u0005eSV\"A\u001a\n\u0005m\u001b$\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0017aC:feZdW\r\u001e)bi\"\fAb]3sm2,G\u000fU1uQ\u0002\na\u0001P5oSRtD\u0003\u00021cG\u0012\u0004\"!\u0019\u0001\u000e\u0003EBQ!\u0013\u0004A\u0002-CQa\u0016\u0004A\u0002aCQ\u0001\u0018\u0004A\u0002-\u000bQ\"\\3ue&\u001c7oQ8oM&<\u0007CA1h\u0013\tA\u0017GA\u0007NKR\u0014\u0018nY:D_:4\u0017nZ\u0001\u0006g&t7n]\u000b\u0002WB\u0019A.]:\u000e\u00035T!A\\8\u0002\u000f5,H/\u00192mK*\u0011\u0001oP\u0001\u000bG>dG.Z2uS>t\u0017B\u0001:n\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005Q<X\"A;\u000b\u0005Y\f\u0014\u0001B:j].L!\u0001_;\u0003\tMKgn[\u0001\u0007g&t7n\u001d\u0011\u0002\u000fM|WO]2fgV\tA\u0010E\u0003~\u0003\u0013\ti!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0002\u0003\u000b\tA!\u001e;jY*\u0011\u0011qA\u0001\u0005U\u00064\u0018-C\u0002\u0002\fy\u0014AcQ8qs>swK]5uK\u0006\u0013(/Y=MSN$\b\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M\u0011'\u0001\u0004t_V\u00148-Z\u0005\u0005\u0003/\t\tB\u0001\u0004T_V\u00148-Z\u0001\tg>,(oY3tA\u0005A!/Z4jgR\u0014\u00180\u0006\u0002\u0002 A!\u0011\u0011EA\u0017\u001b\t\t\u0019CC\u00023\u0003KQA!a\n\u0002*\u0005A1m\u001c3bQ\u0006dWM\u0003\u0002\u0002,\u0005\u00191m\\7\n\t\u0005=\u00121\u0005\u0002\u000f\u001b\u0016$(/[2SK\u001eL7\u000f\u001e:z\u0003%\u0011XmZ5tiJL\b%A\tqe>lW\r\u001e5fkN\u001cVM\u001d<mKR,\"!a\u000e\u0011\u000by\nI$!\u0010\n\u0007\u0005mrH\u0001\u0004PaRLwN\u001c\t\u0004i\u0006}\u0012bAA!k\n\t\u0002K]8nKRDW-^:TKJ4H.\u001a;\u0002+A\u0014x.\\3uQ\u0016,8oU3sm2,Go\u0018\u0013fcR!\u0011qIA'!\rq\u0014\u0011J\u0005\u0004\u0003\u0017z$\u0001B+oSRD\u0011\"a\u0014\u0010\u0003\u0003\u0005\r!a\u000e\u0002\u0007a$\u0013'\u0001\nqe>lW\r\u001e5fkN\u001cVM\u001d<mKR\u0004\u0013a\u0002:v]:LgnZ\u000b\u0003\u0003/\u00022APA-\u0013\r\tYf\u0010\u0002\b\u0005>|G.Z1o\u0003-\u0011XO\u001c8j]\u001e|F%Z9\u0015\t\u0005\u001d\u0013\u0011\r\u0005\n\u0003\u001f\u0012\u0012\u0011!a\u0001\u0003/\n\u0001B];o]&tw\rI\u0001\u0015O\u0016$\bK]8nKRDW-^:IC:$G.\u001a:\u0016\u0005\u0005%\u0004c\u0001;\u0002l%\u0019\u0011QN;\u00039A\u0013x.\\3uQ\u0016,8\u000f\u0013;uaJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe\u0006)1\u000f^1siR!\u0011qIA:\u0011%\t)(\u0006I\u0001\u0002\u0004\t9&A\u000bsK\u001eL7\u000f^3s'R\fG/[2T_V\u00148-Z:\u0002\u001fM$\u0018M\u001d;%I\u00164\u0017-\u001e7uIE*\"!a\u001f+\t\u0005]\u0013QP\u0016\u0003\u0003\u007f\u0002B!!!\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011R \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u000e\u0006\r%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!1\u000f^8q)\t\t9%\u0001\u0004sKB|'\u000f^\u0001\u0012EVLG\u000e\u001a*fO&\u001cHO]=OC6,GcA&\u0002\u001a\"9\u00111C\rA\u0002\u00055\u0011\u0001E4fiN{WO]2fg\nKh*Y7f)\u0011\ty*!-\u0011\r\u0005\u0005\u00161VA\u0007\u001d\u0011\t\u0019+a*\u000f\u00079\u000b)+C\u0001A\u0013\r\tIkP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti+a,\u0003\u0007M+\u0017OC\u0002\u0002*~Ba!a-\u001b\u0001\u0004Y\u0015AC:pkJ\u001cWMT1nK\u0006q!/Z4jgR,'oU8ve\u000e,G\u0003BA$\u0003sCq!a\u0005\u001c\u0001\u0004\ti!\u0001\u0007sK6|g/Z*pkJ\u001cW\r\u0006\u0003\u0002H\u0005}\u0006bBA\n9\u0001\u0007\u0011QB\u0001\u0010e\u0016<\u0017n\u001d;feN{WO]2fg\u0006i!/Z4jgR,'oU5oWN\fQ\"T3ue&\u001c7oU=ti\u0016l\u0007CA1!'\t\u0001S\b\u0006\u0002\u0002H\u0006Q1+\u0013(L?J+u)\u0012-\u0016\u0005\u0005E\u0007\u0003BAj\u00037l!!!6\u000b\t\u0005]\u0017\u0011\\\u0001\t[\u0006$8\r[5oO*\u0019\u00111A \n\t\u0005u\u0017Q\u001b\u0002\u0006%\u0016<W\r_\u0001\f'&s5j\u0018*F\u000f\u0016C\u0006%\u0001\u0007T\u001fV\u00136)R0S\u000b\u001e+\u0005,A\u0007T\u001fV\u00136)R0S\u000b\u001e+\u0005\fI\u0001\f%>cUiX,P%.+%+\u0006\u0002\u0002jB!\u00111^Ay\u001b\t\tiO\u0003\u0003\u0002p\u0006\u0015\u0011\u0001\u00027b]\u001eL1\u0001VAw\u00031\u0011v\nT#`/>\u00136*\u0012*!\u0003-\u0011v\nT#`\u001b\u0006\u001bF+\u0012*\u0002\u0019I{E*R0N\u0003N#VI\u0015\u0011\u0002\u0019M+%K\u0016'F)~\u0003\u0016\t\u0016%\u0002\u001bM+%K\u0016'F)~\u0003\u0016\t\u0016%!\u0003Ei\u0015JT%N\u00032{\u0006k\u0014'M?Vs\u0015\n\u0016\t\u0004{\n\u0005\u0011b\u0001B\u0002}\nAA+[7f+:LG/A\nN\u0013:KU*\u0011'`!>cEj\u0018)F%&{E\tE\u0002?\u0005\u0013I1Aa\u0003@\u0005\rIe\u000e^\u0001\u001aG\",7m['j]&l\u0017\r\u001c)pY2Lgn\u001a)fe&|G\r\u0006\u0004\u0002H\tE!Q\u0003\u0005\b\u0005'q\u0003\u0019AA\u0000\u0003!\u0001x\u000e\u001c7V]&$\bb\u0002B\f]\u0001\u0007!qA\u0001\u000ba>dG\u000eU3sS>$\u0017aE2sK\u0006$X-T3ue&\u001c7oU=ti\u0016lGc\u00021\u0003\u001e\t}!\u0011\u0005\u0005\u0006\u0013>\u0002\ra\u0013\u0005\u0006/>\u0002\r\u0001\u0017\u0005\u00069>\u0002\ra\u0013")
public class MetricsSystem
implements Logging {
    private final String instance;
    private final CelebornConf conf;
    private final String servletPath;
    private final MetricsConfig metricsConfig;
    private final ArrayBuffer<Sink> sinks;
    private final CopyOnWriteArrayList<Source> sources;
    private final MetricRegistry registry;
    private Option<PrometheusServlet> prometheusServlet;
    private boolean running;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static MetricsSystem createMetricsSystem(String string, CelebornConf celebornConf, String string2) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, celebornConf, string2);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static String SERVLET_PATH() {
        return MetricsSystem$.MODULE$.SERVLET_PATH();
    }

    public static String ROLE_MASTER() {
        return MetricsSystem$.MODULE$.ROLE_MASTER();
    }

    public static String ROLE_WORKER() {
        return MetricsSystem$.MODULE$.ROLE_WORKER();
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        MetricsSystem metricsSystem = this;
        synchronized (metricsSystem) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public String instance() {
        return this.instance;
    }

    public String servletPath() {
        return this.servletPath;
    }

    private ArrayBuffer<Sink> sinks() {
        return this.sinks;
    }

    private CopyOnWriteArrayList<Source> sources() {
        return this.sources;
    }

    private MetricRegistry registry() {
        return this.registry;
    }

    private Option<PrometheusServlet> prometheusServlet() {
        return this.prometheusServlet;
    }

    private void prometheusServlet_$eq(Option<PrometheusServlet> x$1) {
        this.prometheusServlet = x$1;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public PrometheusHttpRequestHandler getPrometheusHandler() {
        Predef$.MODULE$.require(this.running(), (Function0 & Serializable & scala.Serializable)() -> "Can only call getServletHandlers on a running MetricsSystem");
        return (PrometheusHttpRequestHandler)this.prometheusServlet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHandler($this.conf)).orNull(Predef$.MODULE$.$conforms());
    }

    public void start(boolean registerStaticSources) {
        Predef$.MODULE$.require(!this.running(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to start a MetricsSystem that is already running");
        this.running_$eq(true);
        if (registerStaticSources) {
            this.registerSources();
        }
        this.registerSinks();
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.start();
            return BoxedUnit.UNIT;
        });
    }

    public boolean start$default$1() {
        return true;
    }

    public void stop() {
        if (this.running()) {
            this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.stop();
                return BoxedUnit.UNIT;
            });
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping a MetricsSystem that is not running");
        }
        this.running_$eq(false);
    }

    public void report() {
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.report();
            return BoxedUnit.UNIT;
        });
    }

    private String buildRegistryName(Source source) {
        return MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.sources()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsSystem.$anonfun$getSourcesByName$1(sourceName, x$5)))).toSeq();
    }

    public void registerSource(Source source) {
        this.sources().add(source);
        try {
            String regName = this.buildRegistryName(source);
            this.registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metrics already registered", e);
        }
    }

    public void removeSource(Source source) {
        this.sources().remove(source);
        String regName = this.buildRegistryName(source);
        this.registry().removeMatching(new MetricFilter(null, regName){
            private final String regName$1;

            public boolean matches(String name, Metric metric) {
                return name.startsWith(this.regName$1);
            }
            {
                this.regName$1 = regName$1;
            }
        });
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            MetricsSystem.$anonfun$registerSources$1(this, kv);
            return BoxedUnit.UNIT;
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            BoxedUnit boxedUnit;
            String classPath = ((Properties)kv._2()).getProperty("class");
            if (classPath != null) {
                try {
                    Object object = kv._1();
                    String string = "prometheusServlet";
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        Object servlet = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class, Seq.class, String.class).newInstance(kv._2(), this.registry(), JavaConverters$.MODULE$.asScalaBufferConverter(this.sources()).asScala(), this.servletPath());
                        this.prometheusServlet_$eq((Option<PrometheusServlet>)new Some((Object)((PrometheusServlet)servlet)));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Object sink = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                    boxedUnit = this.sinks().$plus$eq((Object)((Sink)sink));
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sink class ").append(classPath).append(" cannot be instantiated").toString());
                    throw e;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSourcesByName$1(String sourceName$1, Source x$5) {
        String string = x$5.sourceName();
        String string2 = sourceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$registerSources$1(MetricsSystem $this, Tuple2 kv) {
        String classPath = ((Properties)kv._2()).getProperty("class");
        try {
            Object source = Utils$.MODULE$.classForName(classPath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            $this.registerSource((Source)source);
        }
        catch (Exception e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Source class ").append(classPath).append(" cannot be instantiated").toString(), e);
        }
    }

    public MetricsSystem(String instance, CelebornConf conf, String servletPath) {
        this.instance = instance;
        this.conf = conf;
        this.servletPath = servletPath;
        Logging.$init$(this);
        this.metricsConfig = new MetricsConfig(conf);
        this.sinks = new ArrayBuffer();
        this.sources = new CopyOnWriteArrayList();
        this.registry = new MetricRegistry();
        this.prometheusServlet = None$.MODULE$;
        this.running = false;
        this.metricsConfig.initialize();
    }
}

