/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.Channel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.MapDataPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreditStreamManager {
    private static final Logger logger = LoggerFactory.getLogger(CreditStreamManager.class);
    private final AtomicLong nextStreamId;
    private final ConcurrentHashMap<Long, StreamState> streams;
    private final ConcurrentHashMap<FileInfo, MapDataPartition> activeMapPartitions;
    private final HashMap<String, ExecutorService> storageFetcherPool = new HashMap();
    private int minReadBuffers;
    private int maxReadBuffers;
    private int threadsPerMountPoint;
    private int minBuffersToTriggerRead;
    private final BlockingQueue<DelayedStreamId> recycleStreamIds = new DelayQueue<DelayedStreamId>();
    @GuardedBy(value="lock")
    private volatile Thread recycleThread;
    private final Object lock = new Object();

    public CreditStreamManager(int minReadBuffers, int maxReadBuffers, int threadsPerMountpoint, int minBuffersToTriggerRead) {
        this.nextStreamId = new AtomicLong((long)new Random().nextInt(Integer.MAX_VALUE) * 1000L);
        this.streams = JavaUtils.newConcurrentHashMap();
        this.activeMapPartitions = JavaUtils.newConcurrentHashMap();
        this.minReadBuffers = minReadBuffers;
        this.maxReadBuffers = maxReadBuffers;
        this.threadsPerMountPoint = threadsPerMountpoint;
        this.minBuffersToTriggerRead = minBuffersToTriggerRead;
        MemoryManager.instance().setCreditStreamManager(this);
        logger.debug("Initialize buffer stream manager with {} {} {}", new Object[]{this.minReadBuffers, this.maxReadBuffers, threadsPerMountpoint});
    }

    public long registerStream(Consumer<Long> notifyStreamHandlerCallback, Channel channel, int initialCredit, int startSubIndex, int endSubIndex, FileInfo fileInfo) throws IOException {
        long streamId = this.nextStreamId.getAndIncrement();
        logger.debug("Register stream start from {}, streamId: {}, fileInfo: {}", new Object[]{channel.remoteAddress(), streamId, fileInfo});
        AtomicReference exception = new AtomicReference();
        MapDataPartition mapDataPartition = this.activeMapPartitions.compute(fileInfo, (k, v) -> {
            if (v == null) {
                try {
                    v = new MapDataPartition(this.minReadBuffers, this.maxReadBuffers, this.storageFetcherPool, this.threadsPerMountPoint, fileInfo, id -> this.recycleStream((long)id), this.minBuffersToTriggerRead);
                }
                catch (IOException e) {
                    exception.set(e);
                    return null;
                }
            }
            this.initializeStreamStateAndPartitionReader(channel, startSubIndex, endSubIndex, fileInfo, streamId, (MapDataPartition)v);
            return v;
        });
        if (exception.get() != null) {
            throw (IOException)exception.get();
        }
        mapDataPartition.tryRequestBufferOrRead();
        notifyStreamHandlerCallback.accept(streamId);
        this.addCredit(initialCredit, streamId);
        logger.debug("Register stream streamId: {}, fileInfo: {}", (Object)streamId, (Object)fileInfo);
        return streamId;
    }

    private void initializeStreamStateAndPartitionReader(Channel channel, int startSubIndex, int endSubIndex, FileInfo fileInfo, long streamId, MapDataPartition mapDataPartition) {
        StreamState streamState = new StreamState(channel, fileInfo.getBufferSize(), mapDataPartition);
        this.streams.put(streamId, streamState);
        mapDataPartition.setupDataPartitionReader(startSubIndex, endSubIndex, streamId, channel);
    }

    private void addCredit(MapDataPartition mapDataPartition, int numCredit, long streamId) {
        logger.debug("streamId: {}, add credit: {}", (Object)streamId, (Object)numCredit);
        try {
            if (mapDataPartition != null && numCredit > 0) {
                mapDataPartition.addReaderCredit(numCredit, streamId);
            }
        }
        catch (Throwable e) {
            logger.error("streamId: {}, add credit end: {}", (Object)streamId, (Object)numCredit);
        }
    }

    public void addCredit(int numCredit, long streamId) {
        MapDataPartition mapDataPartition = this.streams.get(streamId).getMapDataPartition();
        this.addCredit(mapDataPartition, numCredit, streamId);
    }

    public void connectionTerminated(Channel channel) {
        for (Map.Entry<Long, StreamState> entry : this.streams.entrySet()) {
            if (entry.getValue().getAssociatedChannel() != channel) continue;
            logger.info("connection closed, clean streamId: {}", (Object)entry.getKey());
            this.recycleStream(entry.getKey());
        }
    }

    public void notifyStreamEndByClient(long streamId) {
        this.recycleStream(streamId);
    }

    public void recycleStream(long streamId) {
        this.recycleStreamIds.add(new DelayedStreamId(streamId));
        this.startRecycleThread();
    }

    @VisibleForTesting
    public int numStreamStates() {
        return this.streams.size();
    }

    @VisibleForTesting
    public int numRecycleStreams() {
        return this.recycleStreamIds.size();
    }

    @VisibleForTesting
    public ConcurrentHashMap<Long, StreamState> getStreams() {
        return this.streams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRecycleThread() {
        if (this.recycleThread == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.recycleThread == null) {
                    this.recycleThread = new Thread(() -> {
                        while (true) {
                            try {
                                while (true) {
                                    DelayedStreamId delayedStreamId = this.recycleStreamIds.take();
                                    this.cleanResource(delayedStreamId.streamId);
                                }
                            }
                            catch (Throwable e) {
                                logger.warn(e.getMessage(), e);
                                continue;
                            }
                            break;
                        }
                    }, "recycle-thread");
                    this.recycleThread.setDaemon(true);
                    this.recycleThread.start();
                    logger.info("start stream recycle thread");
                }
            }
        }
    }

    public void cleanResource(Long streamId) {
        MapDataPartition mapDataPartition;
        logger.debug("received clean stream: {}", (Object)streamId);
        if (this.streams.containsKey(streamId) && (mapDataPartition = this.streams.get(streamId).getMapDataPartition()) != null) {
            if (mapDataPartition.releaseReader(streamId)) {
                this.streams.remove(streamId);
                if (mapDataPartition.getReaders().isEmpty()) {
                    FileInfo fileInfo = mapDataPartition.getFileInfo();
                    this.activeMapPartitions.compute(fileInfo, (k, v) -> {
                        if (v.getReaders().isEmpty()) {
                            v.close();
                            return null;
                        }
                        return v;
                    });
                }
            } else {
                logger.debug("retry clean stream: {}", (Object)streamId);
                this.recycleStreamIds.add(new DelayedStreamId(streamId));
            }
        }
    }

    public long getStreamsCount() {
        return this.streams.size();
    }

    public int getActiveMapPartitionCount() {
        return this.activeMapPartitions.size();
    }

    public static class DelayedStreamId
    implements Delayed {
        private static final long delayTime = 100L;
        private long createMillis = System.currentTimeMillis();
        private long streamId;

        public DelayedStreamId(long streamId) {
            this.createMillis += 100L;
            this.streamId = streamId;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long diff = this.createMillis - System.currentTimeMillis();
            return unit.convert(diff, TimeUnit.MILLISECONDS);
        }

        public long getCreateMillis() {
            return this.createMillis;
        }

        @Override
        public int compareTo(Delayed o) {
            long otherCreateMillis = ((DelayedStreamId)o).getCreateMillis();
            if (this.createMillis < otherCreateMillis) {
                return -1;
            }
            if (this.createMillis > otherCreateMillis) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("DelayedStreamId{");
            sb.append("createMillis=").append(this.createMillis);
            sb.append(", streamId=").append(this.streamId);
            sb.append('}');
            return sb.toString();
        }
    }

    protected class StreamState {
        private Channel associatedChannel;
        private int bufferSize;
        private MapDataPartition mapDataPartition;

        public StreamState(Channel associatedChannel, int bufferSize, MapDataPartition mapDataPartition) {
            this.associatedChannel = associatedChannel;
            this.bufferSize = bufferSize;
            this.mapDataPartition = mapDataPartition;
        }

        public Channel getAssociatedChannel() {
            return this.associatedChannel;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public MapDataPartition getMapDataPartition() {
            return this.mapDataPartition;
        }
    }
}

