/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import org.apache.celeborn.plugin.flink.utils.FlinkUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.ProducerDescriptor;

public class FlinkResultPartitionInfo {
    private final JobID jobID;
    private final PartitionDescriptor partitionDescriptor;
    private final ProducerDescriptor producerDescriptor;

    public FlinkResultPartitionInfo(JobID jobId, PartitionDescriptor partitionDescriptor, ProducerDescriptor producerDescriptor) {
        this.jobID = jobId;
        this.partitionDescriptor = partitionDescriptor;
        this.producerDescriptor = producerDescriptor;
    }

    public ResultPartitionID getResultPartitionId() {
        return new ResultPartitionID(this.partitionDescriptor.getPartitionId(), this.producerDescriptor.getProducerExecutionId());
    }

    public String getShuffleId() {
        return FlinkUtils.toShuffleId(this.jobID, this.partitionDescriptor.getResultId());
    }

    public int getTaskId() {
        return this.partitionDescriptor.getPartitionId().getPartitionNumber();
    }

    public String getAttemptId() {
        return FlinkUtils.toAttemptId(this.producerDescriptor.getProducerExecutionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FlinkResultPartitionInfo{");
        sb.append("jobID=").append(this.jobID);
        sb.append(", partitionDescriptor=").append(this.partitionDescriptor.getPartitionId());
        sb.append(", producerDescriptor=").append(this.producerDescriptor.getProducerExecutionId());
        sb.append('}');
        return sb.toString();
    }
}

