/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder.sqltree;

import java.util.Objects;
import org.apache.cayenne.access.sqlbuilder.NodeTreeVisitor;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;

public class FunctionNode
extends Node {
    private final String functionName;
    private final boolean needParentheses;
    private String alias;

    public static FunctionNode wrap(Node node, String functionName) {
        FunctionNode functionNode = new FunctionNode(functionName, null);
        functionNode.addChild(node);
        return functionNode;
    }

    public FunctionNode(String functionName, String alias) {
        this(functionName, alias, true);
    }

    public FunctionNode(String functionName, String alias, boolean needParentheses) {
        super(NodeType.FUNCTION);
        this.functionName = functionName;
        this.alias = alias;
        this.needParentheses = needParentheses;
    }

    @Override
    public QuotingAppendable append(QuotingAppendable buffer) {
        if (this.skipContent()) {
            buffer.append(' ').append(this.alias);
        } else {
            buffer.append(' ').append(this.functionName);
        }
        return buffer;
    }

    @Override
    public void visit(NodeTreeVisitor visitor) {
        if (this.skipContent()) {
            visitor.onNodeStart(this);
            visitor.onNodeEnd(this);
            return;
        }
        super.visit(visitor);
    }

    @Override
    public void appendChildrenStart(QuotingAppendable buffer) {
        if (this.skipContent()) {
            return;
        }
        if (this.needParentheses) {
            buffer.append('(');
        }
    }

    @Override
    public void appendChildrenEnd(QuotingAppendable buffer) {
        if (this.skipContent()) {
            return;
        }
        if (this.needParentheses) {
            buffer.append(" )");
        }
        if (this.alias != null) {
            buffer.append(" ").appendQuoted(this.alias);
        }
    }

    @Override
    public void appendChildrenSeparator(QuotingAppendable buffer, int childIdx) {
        if (this.skipContent()) {
            return;
        }
        buffer.append(',');
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public Node copy() {
        return new FunctionNode(this.functionName, this.alias, this.needParentheses);
    }

    private boolean notInResultNode() {
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != NodeType.RESULT) continue;
            return false;
        }
        return true;
    }

    protected boolean skipContent() {
        return this.alias != null && this.notInResultNode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionNode that = (FunctionNode)o;
        return Objects.equals(this.functionName, that.functionName) && Objects.equals(this.alias, that.alias);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.functionName, this.alias);
    }
}

