/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.runtime;

import java.util.Collection;
import java.util.List;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.DataChannelQueryFilter;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStoreFactory;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.cache.NestedQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.runtime.DataDomainLoadException;
import org.apache.cayenne.configuration.runtime.DataNodeFactory;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.reflect.generic.ValueComparisonStrategyFactory;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.ResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDomainProvider
implements Provider<DataDomain> {
    private static final Logger logger = LoggerFactory.getLogger(DataDomainProvider.class);
    @Inject
    protected ResourceLocator resourceLocator;
    @Inject
    protected DataChannelDescriptorMerger descriptorMerger;
    @Inject
    protected DataChannelDescriptorLoader loader;
    @Inject
    protected List<DataChannelQueryFilter> queryFilters;
    @Inject
    protected List<DataChannelSyncFilter> syncFilters;
    @Inject(value="cayenne.domain_listeners")
    protected List<Object> listeners;
    @Inject(value="cayenne.project_locations")
    protected List<String> locations;
    @Inject
    protected Injector injector;
    @Inject
    protected QueryCache queryCache;
    @Inject
    protected RuntimeProperties runtimeProperties;
    @Inject
    protected DataNodeFactory dataNodeFactory;

    @Override
    public DataDomain get() throws ConfigurationException {
        try {
            return this.createAndInitDataDomain();
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            String causeMessage = e.getMessage();
            String message = causeMessage != null && causeMessage.length() > 0 ? causeMessage : e.getClass().getName();
            throw new DataDomainLoadException("DataDomain startup failed: %s", (Throwable)e, message);
        }
    }

    protected DataDomain createDataDomain(String name) {
        return new DataDomain(name);
    }

    protected DataDomain createAndInitDataDomain() throws Exception {
        Collection<DataNode> allNodes;
        DataChannelDescriptor descriptor = this.loadDescriptor();
        DataDomain dataDomain = this.createDataDomain(descriptor.getName());
        dataDomain.setMaxIdQualifierSize(this.runtimeProperties.getInt("cayenne.max_id_qualifier_size", -1));
        dataDomain.setQueryCache(new NestedQueryCache(this.queryCache));
        dataDomain.setEntitySorter(this.injector.getInstance(EntitySorter.class));
        dataDomain.setEventManager(this.injector.getInstance(EventManager.class));
        dataDomain.setDataRowStoreFactory(this.injector.getInstance(DataRowStoreFactory.class));
        dataDomain.initWithProperties(descriptor.getProperties());
        for (DataMap dataMap : descriptor.getDataMaps()) {
            dataDomain.addDataMap(dataMap);
        }
        dataDomain.getEntityResolver().applyDBLayerDefaults();
        dataDomain.getEntityResolver().setValueObjectTypeRegistry(this.injector.getInstance(ValueObjectTypeRegistry.class));
        dataDomain.getEntityResolver().setValueComparisonStrategyFactory(this.injector.getInstance(ValueComparisonStrategyFactory.class));
        dataDomain.getEntityResolver().setObjectFactory(this.injector.getInstance(AdhocObjectFactory.class));
        for (DataNodeDescriptor nodeDescriptor : descriptor.getNodeDescriptors()) {
            this.addDataNode(dataDomain, nodeDescriptor);
        }
        DataNode defaultNode = null;
        if (descriptor.getDefaultNodeName() != null) {
            defaultNode = dataDomain.getDataNode(descriptor.getDefaultNodeName());
        }
        if (defaultNode == null && (allNodes = dataDomain.getDataNodes()).size() == 1) {
            defaultNode = allNodes.iterator().next();
        }
        if (defaultNode != null) {
            logger.info("setting DataNode '" + defaultNode.getName() + "' as default, used by all unlinked DataMaps");
            dataDomain.setDefaultNode(defaultNode);
        }
        for (DataChannelQueryFilter dataChannelQueryFilter : this.queryFilters) {
            dataDomain.addQueryFilter(dataChannelQueryFilter);
        }
        for (DataChannelSyncFilter dataChannelSyncFilter : this.syncFilters) {
            dataDomain.addSyncFilter(dataChannelSyncFilter);
        }
        for (Object object : this.listeners) {
            dataDomain.addListener(object);
        }
        return dataDomain;
    }

    protected DataChannelDescriptor loadDescriptor() {
        DataChannelDescriptor descriptor = this.locations.isEmpty() ? new DataChannelDescriptor() : this.loadDescriptorFromConfigs();
        String nameOverride = this.runtimeProperties.get("cayenne.domain.name");
        if (nameOverride != null) {
            descriptor.setName(nameOverride);
        }
        return descriptor;
    }

    protected DataNode addDataNode(DataDomain dataDomain, DataNodeDescriptor nodeDescriptor) throws Exception {
        DataNode dataNode = this.dataNodeFactory.createDataNode(nodeDescriptor);
        for (String dataMapName : nodeDescriptor.getDataMapNames()) {
            dataNode.addDataMap(dataDomain.getDataMap(dataMapName));
        }
        dataDomain.addNode(dataNode);
        return dataNode;
    }

    private DataChannelDescriptor loadDescriptorFromConfigs() {
        long t0 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("starting configuration loading: " + String.valueOf(this.locations));
        }
        DataChannelDescriptor[] descriptors = new DataChannelDescriptor[this.locations.size()];
        for (int i = 0; i < this.locations.size(); ++i) {
            ConfigurationTree<DataChannelDescriptor> tree;
            String location = this.locations.get(i);
            Collection<Resource> configurations = this.resourceLocator.findResources(location);
            if (configurations.isEmpty()) {
                throw new DataDomainLoadException("Configuration resource \"%s\" is not found.", location);
            }
            Resource configurationResource = configurations.iterator().next();
            if (configurations.size() > 1) {
                logger.info("found " + configurations.size() + " configurations for " + location + ", will use the first one: " + String.valueOf(configurationResource.getURL()));
            }
            if (!(tree = this.loader.load(configurationResource)).getLoadFailures().isEmpty()) {
                throw new DataDomainLoadException(tree, "Error loading DataChannelDescriptor", new Object[0]);
            }
            descriptors[i] = tree.getRootNode();
        }
        long t1 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("finished configuration loading in " + (t1 - t0) + " ms.");
        }
        return this.descriptorMerger.merge(descriptors);
    }
}

