/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.project.validation.Inspection;

public class ValidationConfig {
    private final Set<Inspection> enabledInspections;

    public ValidationConfig() {
        this(EnumSet.allOf(Inspection.class));
    }

    public ValidationConfig(ValidationConfig other) {
        this(other.enabledInspections);
    }

    public ValidationConfig(Set<Inspection> enabledInspections) {
        this.enabledInspections = Collections.unmodifiableSet(EnumSet.copyOf(enabledInspections));
    }

    public Set<Inspection> getEnabledInspections() {
        return this.enabledInspections;
    }

    public boolean isEnabled(Inspection inspection) {
        return this.enabledInspections.contains((Object)inspection);
    }

    public static ValidationConfig fromMetadata(DataChannelMetaData metaData, DataChannelDescriptor dataChannel) {
        return Optional.ofNullable((ValidationConfig)metaData.get((ConfigurationNode)dataChannel, ValidationConfig.class)).orElseGet(ValidationConfig::new);
    }
}

