/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ObjRelationshipValidator
extends ConfigurationNodeValidator<ObjRelationship> {
    public ObjRelationshipValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(ObjRelationship node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.OBJ_RELATIONSHIP_NO_NAME, this::checkForName).performIfEnabled(Inspection.OBJ_RELATIONSHIP_NAME_DUPLICATE, this::checkForNameDuplicates).performIfEnabled(Inspection.OBJ_RELATIONSHIP_INVALID_NAME, this::validateName).performIfEnabled(Inspection.OBJ_RELATIONSHIP_NO_TARGET, this::checkForTarget).performIfEnabled(Inspection.OBJ_RELATIONSHIP_TARGET_NOT_PK, this::checkForPK).performIfEnabled(Inspection.OBJ_RELATIONSHIP_INVALID_REVERSED, this::validateReverse).performIfEnabled(Inspection.OBJ_RELATIONSHIP_SEMANTIC_DUPLICATE, this::checkForSemanticDuplicates).performIfEnabled(Inspection.OBJ_RELATIONSHIP_INVALID_MAPPING, this::validateMapping).performIfEnabled(Inspection.OBJ_RELATIONSHIP_NULLIFY_NOT_NULL, this::validateDeleteRule).performIfEnabled(Inspection.OBJ_RELATIONSHIP_DUPLICATE_IN_ENTITY, this::checkForDuplicatesInEntity);
    }

    private void checkForName(ObjRelationship relationship, ValidationResult validationResult) {
        if (Util.isEmptyString((CharSequence)relationship.getName())) {
            this.addFailure(validationResult, relationship, "Unnamed ObjRelationship", new Object[0]);
        }
    }

    private void checkForNameDuplicates(ObjRelationship relationship, ValidationResult validationResult) {
        if (relationship.getSourceEntity().getAttribute(relationship.getName()) != null) {
            this.addFailure(validationResult, relationship, "ObjRelationship '%s' has the same name as one of ObjAttributes", this.toString(relationship));
        }
    }

    private void validateName(ObjRelationship relationship, ValidationResult validationResult) {
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String invalidChars = helper.invalidCharsInObjPathComponent(relationship.getName());
        if (invalidChars != null) {
            this.addFailure(validationResult, relationship, "ObjRelationship name '%s' contains invalid characters: %s", this.toString(relationship), invalidChars);
        } else if (helper.invalidPersistentObjectProperty(relationship.getName())) {
            this.addFailure(validationResult, relationship, "ObjRelationship name '%s' is a reserved word", this.toString(relationship));
        }
    }

    private void checkForTarget(ObjRelationship relationship, ValidationResult validationResult) {
        if (relationship.getTargetEntity() == null) {
            this.addFailure(validationResult, relationship, "ObjRelationship '%s' has no target entity", this.toString(relationship));
        }
    }

    private void checkForPK(ObjRelationship relationship, ValidationResult validationResult) {
        if (relationship.getDbRelationships().isEmpty() || relationship.isToPK()) {
            return;
        }
        ObjRelationship reverseRelationship = relationship.getReverseRelationship();
        if (reverseRelationship != null && !relationship.getDbRelationships().isEmpty() && !reverseRelationship.isToPK()) {
            this.addFailure(validationResult, relationship, "ObjRelationship '%s' has join not to PK. This is not fully supported by Cayenne.", this.toString(relationship));
        }
    }

    private void validateReverse(ObjRelationship relationship, ValidationResult validationResult) {
        if (relationship.getReverseRelationship() == null) {
            return;
        }
        ObjRelationship revRel = relationship.getReverseRelationship();
        if (relationship.getSourceEntity() != revRel.getTargetEntity() || relationship.getTargetEntity() != revRel.getSourceEntity()) {
            this.addFailure(validationResult, revRel, "Usage of super entity's relationships '%s' as reversed relationships for sub entity is discouraged", this.toString(revRel));
        }
    }

    private void checkForSemanticDuplicates(ObjRelationship relationship, ValidationResult validationResult) {
        ObjEntity entity = relationship.getSourceEntity();
        for (ObjRelationship otherRelationship : entity.getRelationships()) {
            if (relationship.getDbRelationshipPath() == null || relationship == otherRelationship || relationship.getTargetEntity() != otherRelationship.getTargetEntity() || relationship.getSourceEntity() != otherRelationship.getSourceEntity() || !relationship.getDbRelationshipPath().equals(otherRelationship.getDbRelationshipPath())) continue;
            this.addFailure(validationResult, relationship, "ObjectRelationship '%s' duplicates relationship '%s'", this.toString(relationship), this.toString(otherRelationship));
        }
    }

    private void validateMapping(ObjRelationship relationship, ValidationResult validationResult) {
        List dbRels = relationship.getDbRelationships();
        if (dbRels.isEmpty()) {
            this.addFailure(validationResult, relationship, "ObjRelationship '%s' has no DbRelationship mapping", this.toString(relationship));
        } else {
            DbEntity expectedSrc = relationship.getSourceEntity().getDbEntity();
            DbEntity expectedTarget = relationship.getTargetEntity().getDbEntity();
            if (((DbRelationship)dbRels.get(0)).getSourceEntity() != expectedSrc || ((DbRelationship)dbRels.get(dbRels.size() - 1)).getTargetEntity() != expectedTarget) {
                this.addFailure(validationResult, relationship, "ObjRelationship '%s' has incomplete DbRelationship mapping", this.toString(relationship));
            }
        }
    }

    private void validateDeleteRule(ObjRelationship relationship, ValidationResult validationResult) {
        if (!relationship.isToMany() || relationship.isFlattened() || relationship.getDeleteRule() != 1) {
            return;
        }
        ObjRelationship inverse = relationship.getReverseRelationship();
        if (inverse == null) {
            return;
        }
        DbRelationship firstRel = (DbRelationship)inverse.getDbRelationships().get(0);
        Iterator attributePairIterator = firstRel.getJoins().iterator();
        boolean check = true;
        while (attributePairIterator.hasNext()) {
            DbJoin pair = (DbJoin)attributePairIterator.next();
            if (pair.getSource().isMandatory()) continue;
            check = false;
            break;
        }
        if (check) {
            this.addFailure(validationResult, relationship, "ObjRelationship '%s' has a Nullify delete rule and a mandatory reverse relationship", this.toString(relationship));
        }
    }

    private void checkForDuplicatesInEntity(ObjRelationship relationship, ValidationResult validationResult) {
        if (relationship == null || relationship.getName() == null || relationship.getTargetEntityName() == null) {
            return;
        }
        String dbRelationshipPath = relationship.getTargetEntityName() + "." + relationship.getDbRelationshipPath();
        ObjEntity entity = relationship.getSourceEntity();
        for (ObjRelationship otherRelationship : entity.getRelationships()) {
            String otherDbRelationshipPath;
            if (relationship == otherRelationship || !dbRelationshipPath.equals(otherDbRelationshipPath = otherRelationship.getTargetEntityName() + "." + otherRelationship.getDbRelationshipPath())) continue;
            this.addFailure(validationResult, relationship, "ObjEntity '%s' contains a duplicate ObjRelationship mapping ('%s' -> '%s')", entity.getName(), relationship.getName(), dbRelationshipPath);
            return;
        }
    }

    private String toString(ObjRelationship relationship) {
        if (relationship.getSourceEntity() == null) {
            return "[null source entity]." + relationship.getName();
        }
        return relationship.getSourceEntity().getName() + "." + relationship.getName();
    }
}

