/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.oracle.OracleBatchAction;
import org.apache.cayenne.dba.oracle.OracleProcedureAction;
import org.apache.cayenne.dba.oracle.OracleSQLTemplateAction;
import org.apache.cayenne.dba.oracle.OracleSelectAction;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLTemplate;

class OracleActionBuilder
extends JdbcActionBuilder {
    OracleActionBuilder(DataNode dataNode) {
        super(dataNode);
    }

    @Override
    public SQLAction sqlAction(SQLTemplate query) {
        return new OracleSQLTemplateAction(query, this.dataNode);
    }

    @Override
    public SQLAction batchAction(BatchQuery query) {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.dataNode.getAdapter().supportsBatchUpdates();
        return new OracleBatchAction(query, this.dataNode, runningAsBatch);
    }

    @Override
    public SQLAction procedureAction(ProcedureQuery query) {
        return new OracleProcedureAction(query, this.dataNode);
    }

    @Override
    public <T> SQLAction objectSelectAction(FluentSelect<T, ?> query) {
        return new OracleSelectAction(query, this.dataNode);
    }
}

