/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.cayenne.access.translator.select.PathTranslationResult;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;

abstract class PathProcessor<T extends Entity<?, ?, ?>>
implements PathTranslationResult {
    public static final char SPLIT_PATH_INDICATOR = '#';
    public static final String DB_PATH_ALIAS_INDICATOR = "db:";
    protected final Map<String, String> pathSplitAliases;
    protected final TranslatorContext context;
    protected final List<CayennePath> attributePaths;
    protected final List<DbAttribute> attributes;
    protected CayennePath currentDbPath;
    protected boolean lastComponent;
    private boolean isOuterJoin;
    protected T entity;
    protected DbRelationship relationship;
    protected String currentAlias;

    public PathProcessor(TranslatorContext context, T entity) {
        this.context = Objects.requireNonNull(context);
        this.entity = (Entity)Objects.requireNonNull(entity);
        this.pathSplitAliases = context.getMetadata().getPathSplitAliases();
        this.currentDbPath = CayennePath.EMPTY_PATH;
        this.attributes = new ArrayList<DbAttribute>(1);
        this.attributePaths = new ArrayList<CayennePath>(1);
    }

    public PathTranslationResult process(CayennePath path) {
        if (path.marker() != 0) {
            this.currentDbPath = this.currentDbPath.withMarker(path.marker());
        }
        List<CayennePathSegment> segments = path.segments();
        int size = segments.size();
        for (int i = 0; i < size; ++i) {
            CayennePathSegment segment = segments.get(i);
            String next = segment.value();
            this.isOuterJoin = false;
            this.lastComponent = i == size - 1;
            String alias = this.pathSplitAliases.get(next);
            if (alias != null) {
                this.currentAlias = next;
                this.processAliasedAttribute(next, alias);
                this.currentAlias = null;
                continue;
            }
            this.isOuterJoin = segment.isOuterJoin();
            this.processNormalAttribute(next);
        }
        return this;
    }

    protected void addAttribute(CayennePath path, DbAttribute attribute) {
        this.attributePaths.add(path);
        this.attributes.add(attribute);
    }

    protected abstract void processAliasedAttribute(String var1, String var2);

    protected abstract void processNormalAttribute(String var1);

    @Override
    public List<DbAttribute> getDbAttributes() {
        return this.attributes;
    }

    @Override
    public List<CayennePath> getAttributePaths() {
        return this.attributePaths;
    }

    @Override
    public Optional<DbRelationship> getDbRelationship() {
        if (this.relationship == null) {
            return Optional.empty();
        }
        return Optional.of(this.relationship);
    }

    @Override
    public CayennePath getFinalPath() {
        return this.currentDbPath;
    }

    protected void appendCurrentPath(String nextSegment) {
        CayennePathSegment segment = this.currentAlias != null ? CayennePath.segmentOf("#" + this.currentAlias) : CayennePath.segmentOf(nextSegment, this.isOuterJoin);
        this.currentDbPath = this.currentDbPath.dot(segment);
    }

    public boolean isOuterJoin() {
        return this.isOuterJoin;
    }
}

