/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.handlers;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.project.upgrade.UpgradeUnit;
import org.apache.cayenne.project.upgrade.handlers.UpgradeHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UpgradeHandler_V8
implements UpgradeHandler {
    @Override
    public String getVersion() {
        return "8";
    }

    @Override
    public void processProjectDom(UpgradeUnit upgradeUnit) {
        Element domain = upgradeUnit.getDocument().getDocumentElement();
        domain.setAttribute("project-version", this.getVersion());
    }

    @Override
    public void processDataMapDom(UpgradeUnit upgradeUnit) {
        NodeList queryNodes;
        Element dataMap = upgradeUnit.getDocument().getDocumentElement();
        dataMap.setAttribute("xmlns", "http://cayenne.apache.org/schema/8/modelMap");
        dataMap.setAttribute("xsi:schemaLocation", "http://cayenne.apache.org/schema/8/modelMap https://cayenne.apache.org/schema/8/modelMap.xsd");
        dataMap.setAttribute("project-version", this.getVersion());
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            queryNodes = (NodeList)xpath.evaluate("/data-map/query", upgradeUnit.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception ex) {
            return;
        }
        for (int j = 0; j < queryNodes.getLength(); ++j) {
            String queryType;
            Element queryElement = (Element)queryNodes.item(j);
            String factory = queryElement.getAttribute("factory");
            if (factory == null || factory.isEmpty()) continue;
            switch (factory) {
                case "org.apache.cayenne.map.SelectQueryBuilder": {
                    queryType = "SelectQuery";
                    break;
                }
                case "org.apache.cayenne.map.SQLTemplateBuilder": {
                    queryType = "SQLTemplate";
                    break;
                }
                case "org.apache.cayenne.map.EjbqlBuilder": {
                    queryType = "EJBQLQuery";
                    break;
                }
                case "org.apache.cayenne.map.ProcedureQueryBuilder": {
                    queryType = "ProcedureQuery";
                    break;
                }
                default: {
                    throw new ConfigurationException("Unknown query factory: " + factory, new Object[0]);
                }
            }
            queryElement.setAttribute("type", queryType);
            queryElement.removeAttribute("factory");
        }
    }
}

