/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/
package org.apache.cayenne.unit.di.server;

import java.sql.Types;

import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.jdbc.DBHelper;

@UseServerRuntime(CayenneProjects.PEOPLE_PROJECT)
public class PeopleProjectCase extends ServerCase {

	@Inject
	protected DBHelper dbHelper;

	@Override
	public void cleanUpDB() throws Exception {
		// manually break circular deps
		dbHelper.update("PERSON").set("DEPARTMENT_ID", null, Types.INTEGER).execute();
		super.cleanUpDB();
	}
}
