package org.apache.cayenne.testdo.inherit.auto;

import java.util.List;

import org.apache.cayenne.testdo.inherit.AbstractPerson;
import org.apache.cayenne.testdo.inherit.Address;
import org.apache.cayenne.testdo.inherit.Department;

/**
 * Class _Employee was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Employee extends AbstractPerson {

    public static final String SALARY_PROPERTY = "salary";
    public static final String ADDRESSES_PROPERTY = "addresses";
    public static final String TO_DEPARTMENT_PROPERTY = "toDepartment";

    public static final String PERSON_ID_PK_COLUMN = "PERSON_ID";

    public void setSalary(Float salary) {
        writeProperty(SALARY_PROPERTY, salary);
    }
    public Float getSalary() {
        return (Float)readProperty(SALARY_PROPERTY);
    }

    public void addToAddresses(Address obj) {
        addToManyTarget(ADDRESSES_PROPERTY, obj, true);
    }
    public void removeFromAddresses(Address obj) {
        removeToManyTarget(ADDRESSES_PROPERTY, obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<Address> getAddresses() {
        return (List<Address>)readProperty(ADDRESSES_PROPERTY);
    }


    public void setToDepartment(Department toDepartment) {
        setToOneTarget(TO_DEPARTMENT_PROPERTY, toDepartment, true);
    }

    public Department getToDepartment() {
        return (Department)readProperty(TO_DEPARTMENT_PROPERTY);
    }


}
