/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics.instance;

import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.NamedMetric;

public class InstanceResourceMetrics {
    public static final String DOMAIN = "Sidecar.CassInstance.Resource";
    protected final MetricRegistry metricRegistry;
    public final NamedMetric<DeltaGauge> insufficientStagingSpace;
    public final NamedMetric<DefaultSettableGauge<Long>> usableStagingSpace;

    public InstanceResourceMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
        this.insufficientStagingSpace = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(DOMAIN).withName("InsufficientStagingSpace").build();
        this.usableStagingSpace = NamedMetric.builder(name -> (DefaultSettableGauge)metricRegistry.gauge(name, () -> new DefaultSettableGauge((Object)0L))).withDomain(DOMAIN).withName("UsableStagingSpace").build();
    }
}

