/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.job;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.exceptions.OperationalJobConflictException;
import org.apache.cassandra.sidecar.job.OperationalJob;
import org.apache.cassandra.sidecar.job.OperationalJobTracker;

@Singleton
public class OperationalJobManager {
    private final OperationalJobTracker jobTracker;
    private final TaskExecutorPool internalExecutorPool;

    @Inject
    public OperationalJobManager(OperationalJobTracker jobTracker, ExecutorPools executorPools) {
        this.jobTracker = jobTracker;
        this.internalExecutorPool = executorPools.internal();
    }

    public List<OperationalJob> allInflightJobs() {
        return this.jobTracker.jobsView().values().stream().filter(j -> !j.asyncResult().isComplete()).collect(Collectors.toList());
    }

    public OperationalJob getJobIfExists(UUID jobId) {
        return this.jobTracker.get(jobId);
    }

    public void trySubmitJob(OperationalJob job) throws OperationalJobConflictException {
        this.checkConflict(job);
        this.jobTracker.computeIfAbsent(job.jobId(), jobId -> {
            this.internalExecutorPool.executeBlocking(job::execute);
            return job;
        });
    }

    private void checkConflict(OperationalJob job) throws OperationalJobConflictException {
        if (!this.jobTracker.inflightJobsByOperation(job.name()).isEmpty() || job.isRunningOnCassandra()) {
            throw new OperationalJobConflictException("The same operational job is already running on Cassandra. operationName='" + job.name() + "'");
        }
    }
}

