/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class LongSerializer
extends TypeSerializer<Long> {
    public static final LongSerializer instance = new LongSerializer();

    @Override
    public <V> Long deserialize(V value, ValueAccessor<V> accessor) {
        return accessor.isEmpty(value) ? null : Long.valueOf(accessor.toLong(value));
    }

    @Override
    public ByteBuffer serialize(Long value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) != 8 && !accessor.isEmpty(value)) {
            throw new MarshalException(String.format("Expected 8 or 0 byte long (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(Long value) {
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }
}

