/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.StringJoiner;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnSubselection;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFilter {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFilter.class);
    public static final Serializer serializer = new Serializer();
    private final boolean isFetchAll;
    private final PartitionColumns fetched;
    private final PartitionColumns queried;
    private final SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections;

    private ColumnFilter(boolean isFetchAll, PartitionColumns fetched, PartitionColumns queried, SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections) {
        assert (!isFetchAll || fetched != null);
        assert (isFetchAll || queried != null);
        this.isFetchAll = isFetchAll;
        this.fetched = isFetchAll ? fetched : queried;
        this.queried = queried;
        this.subSelections = subSelections;
    }

    public static ColumnFilter all(CFMetaData metadata) {
        return new ColumnFilter(true, metadata.partitionColumns(), null, null);
    }

    public static ColumnFilter selection(PartitionColumns columns) {
        return new ColumnFilter(false, null, columns, null);
    }

    public static ColumnFilter selection(CFMetaData metadata, PartitionColumns queried) {
        return new ColumnFilter(true, metadata.partitionColumns(), Gossiper.instance.isAnyNodeOn30() ? null : queried, null);
    }

    public PartitionColumns fetchedColumns() {
        return this.fetched;
    }

    public PartitionColumns queriedColumns() {
        return this.queried == null ? this.fetched : this.queried;
    }

    public boolean fetchesAllColumns() {
        return this.isFetchAll;
    }

    public boolean allFetchedColumnsAreQueried() {
        return !this.isFetchAll || this.queried == null && this.subSelections == null;
    }

    public boolean fetches(ColumnDefinition column) {
        return this.isFetchAll || this.queried.contains(column);
    }

    public boolean fetchedColumnIsQueried(ColumnDefinition column) {
        return !this.isFetchAll || this.queried == null || this.queried.contains(column);
    }

    public boolean fetchedCellIsQueried(ColumnDefinition column, CellPath path) {
        assert (path != null);
        if (!this.fetchedColumnIsQueried(column)) {
            return false;
        }
        if (this.subSelections == null) {
            return true;
        }
        SortedSet s = this.subSelections.get((Object)column.name);
        if (s.isEmpty()) {
            return true;
        }
        for (ColumnSubselection subSel : s) {
            if (subSel.compareInclusionOf(path) != 0) continue;
            return true;
        }
        return false;
    }

    public Tester newTester(ColumnDefinition column) {
        if (this.subSelections == null || !column.isComplex()) {
            return null;
        }
        SortedSet s = this.subSelections.get((Object)column.name);
        if (s.isEmpty()) {
            return null;
        }
        return new Tester(this.isFetchAll, s.iterator());
    }

    public static Builder allColumnsBuilder(CFMetaData metadata) {
        return new Builder(metadata);
    }

    public static Builder selectionBuilder() {
        return new Builder(null);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ColumnFilter)) {
            return false;
        }
        ColumnFilter otherCf = (ColumnFilter)other;
        return otherCf.isFetchAll == this.isFetchAll && Objects.equals(otherCf.fetched, this.fetched) && Objects.equals(otherCf.queried, this.queried) && Objects.equals(otherCf.subSelections, this.subSelections);
    }

    public String toString() {
        if (this.isFetchAll && this.queried == null) {
            return "*/*";
        }
        String prefix = "";
        if (this.isFetchAll) {
            prefix = "*/";
        }
        if (this.queried.isEmpty()) {
            return prefix + "[]";
        }
        return prefix + this.toString(false);
    }

    public String toCQLString() {
        if (this.queried == null || this.queried.isEmpty()) {
            return "*";
        }
        return this.toString(true);
    }

    private String toString(boolean cql) {
        StringJoiner joiner;
        Iterator<ColumnDefinition> columns = this.queried.selectOrderIterator();
        StringJoiner stringJoiner = joiner = cql ? new StringJoiner(", ") : new StringJoiner(", ", "[", "]");
        while (columns.hasNext()) {
            SortedSet s;
            ColumnDefinition column = columns.next();
            String columnName = cql ? column.name.toCQLString() : String.valueOf(column.name);
            SortedSet sortedSet = s = this.subSelections != null ? this.subSelections.get((Object)column.name) : Collections.emptySortedSet();
            if (s.isEmpty()) {
                joiner.add(columnName);
                continue;
            }
            s.forEach(subSel -> joiner.add(String.format("%s%s", columnName, subSel)));
        }
        return joiner.toString();
    }

    public static class Serializer {
        private static final int IS_FETCH_ALL_MASK = 1;
        private static final int HAS_QUERIED_MASK = 2;
        private static final int HAS_SUB_SELECTIONS_MASK = 4;

        private static int makeHeaderByte(ColumnFilter selection) {
            return (selection.isFetchAll ? 1 : 0) | (selection.queried != null ? 2 : 0) | (selection.subSelections != null ? 4 : 0);
        }

        public void serialize(ColumnFilter selection, DataOutputPlus out, int version) throws IOException {
            out.writeByte(Serializer.makeHeaderByte(selection));
            if (version >= 11 && selection.isFetchAll) {
                Columns.serializer.serialize(((ColumnFilter)selection).fetched.statics, out);
                Columns.serializer.serialize(((ColumnFilter)selection).fetched.regulars, out);
            }
            if (selection.queried != null) {
                Columns.serializer.serialize(((ColumnFilter)selection).queried.statics, out);
                Columns.serializer.serialize(((ColumnFilter)selection).queried.regulars, out);
            }
            if (selection.subSelections != null) {
                out.writeUnsignedVInt(selection.subSelections.size());
                for (ColumnSubselection subSel : selection.subSelections.values()) {
                    ColumnSubselection.serializer.serialize(subSel, out, version);
                }
            }
        }

        public ColumnFilter deserialize(DataInputPlus in, int version, CFMetaData metadata) throws IOException {
            Columns regulars;
            Columns statics;
            int header = in.readUnsignedByte();
            boolean isFetchAll = (header & 1) != 0;
            boolean hasQueried = (header & 2) != 0;
            boolean hasSubSelections = (header & 4) != 0;
            PartitionColumns fetched = null;
            PartitionColumns queried = null;
            if (isFetchAll) {
                if (version >= 11) {
                    statics = Columns.serializer.deserialize(in, metadata);
                    regulars = Columns.serializer.deserialize(in, metadata);
                    fetched = new PartitionColumns(statics, regulars);
                } else {
                    fetched = metadata.partitionColumns();
                }
            }
            if (hasQueried) {
                statics = Columns.serializer.deserialize(in, metadata);
                regulars = Columns.serializer.deserialize(in, metadata);
                queried = new PartitionColumns(statics, regulars);
            }
            TreeMultimap subSelections = null;
            if (hasSubSelections) {
                subSelections = TreeMultimap.create(Comparator.naturalOrder(), Comparator.naturalOrder());
                int size = (int)in.readUnsignedVInt();
                for (int i = 0; i < size; ++i) {
                    ColumnSubselection subSel = ColumnSubselection.serializer.deserialize(in, version, metadata);
                    subSelections.put((Object)subSel.column().name, (Object)subSel);
                }
            }
            if (isFetchAll && queried != null && Gossiper.instance.isAnyNodeOn30()) {
                logger.trace("Deserialized column filter will be automatically converted to query all columns because 3.0 nodes are present in the cluster");
                queried = null;
            }
            return new ColumnFilter(isFetchAll, fetched, queried, (SortedSetMultimap)subSelections);
        }

        public long serializedSize(ColumnFilter selection, int version) {
            long size = 1L;
            if (version >= 11 && selection.isFetchAll) {
                size += Columns.serializer.serializedSize(((ColumnFilter)selection).fetched.statics);
                size += Columns.serializer.serializedSize(((ColumnFilter)selection).fetched.regulars);
            }
            if (selection.queried != null) {
                size += Columns.serializer.serializedSize(((ColumnFilter)selection).queried.statics);
                size += Columns.serializer.serializedSize(((ColumnFilter)selection).queried.regulars);
            }
            if (selection.subSelections != null) {
                size += (long)TypeSizes.sizeofUnsignedVInt(selection.subSelections.size());
                for (ColumnSubselection subSel : selection.subSelections.values()) {
                    size += ColumnSubselection.serializer.serializedSize(subSel, version);
                }
            }
            return size;
        }
    }

    public static class Builder {
        private final CFMetaData metadata;
        private PartitionColumns.Builder queriedBuilder;
        private List<ColumnSubselection> subSelections;

        private Builder(CFMetaData metadata) {
            this.metadata = metadata;
        }

        public Builder add(ColumnDefinition c) {
            if (this.queriedBuilder == null) {
                this.queriedBuilder = PartitionColumns.builder();
            }
            this.queriedBuilder.add(c);
            return this;
        }

        public Builder addAll(Iterable<ColumnDefinition> columns) {
            if (this.queriedBuilder == null) {
                this.queriedBuilder = PartitionColumns.builder();
            }
            this.queriedBuilder.addAll(columns);
            return this;
        }

        private Builder addSubSelection(ColumnSubselection subSelection) {
            this.add(subSelection.column());
            if (this.subSelections == null) {
                this.subSelections = new ArrayList<ColumnSubselection>();
            }
            this.subSelections.add(subSelection);
            return this;
        }

        public Builder slice(ColumnDefinition c, CellPath from, CellPath to) {
            return this.addSubSelection(ColumnSubselection.slice(c, from, to));
        }

        public Builder select(ColumnDefinition c, CellPath elt) {
            return this.addSubSelection(ColumnSubselection.element(c, elt));
        }

        public ColumnFilter build() {
            PartitionColumns queried;
            boolean isFetchAll = this.metadata != null;
            PartitionColumns partitionColumns = queried = this.queriedBuilder == null ? null : this.queriedBuilder.build();
            if (!isFetchAll && queried == null) {
                queried = PartitionColumns.NONE;
            }
            TreeMultimap s = null;
            if (this.subSelections != null) {
                s = TreeMultimap.create(Comparator.naturalOrder(), Comparator.naturalOrder());
                for (ColumnSubselection subSelection : this.subSelections) {
                    s.put((Object)subSelection.column().name, (Object)subSelection);
                }
            }
            if (isFetchAll && queried != null && Gossiper.instance.isAnyNodeOn30()) {
                logger.trace("Column filter will be automatically converted to query all columns because 3.0 nodes are present in the cluster");
                queried = null;
            }
            return new ColumnFilter(isFetchAll, isFetchAll ? this.metadata.partitionColumns() : null, queried, (SortedSetMultimap)s);
        }
    }

    public static class Tester {
        private final boolean isFetchAll;
        private ColumnSubselection current;
        private final Iterator<ColumnSubselection> iterator;

        private Tester(boolean isFetchAll, Iterator<ColumnSubselection> iterator) {
            this.isFetchAll = isFetchAll;
            this.iterator = iterator;
        }

        public boolean fetches(CellPath path) {
            return this.isFetchAll || this.hasSubselection(path);
        }

        public boolean fetchedCellIsQueried(CellPath path) {
            return !this.isFetchAll || this.hasSubselection(path);
        }

        private boolean hasSubselection(CellPath path) {
            while (this.current != null || this.iterator.hasNext()) {
                int cmp;
                if (this.current == null) {
                    this.current = this.iterator.next();
                }
                if ((cmp = this.current.compareInclusionOf(path)) == 0) {
                    return true;
                }
                if (cmp < 0) {
                    return false;
                }
                this.current = null;
            }
            return false;
        }
    }
}

