/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.PeekingIterator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.MerkleTree;
import org.slf4j.Logger;

public class MerkleTrees
implements Iterable<Map.Entry<Range<Token>, MerkleTree>> {
    public static final MerkleTreesSerializer serializer = new MerkleTreesSerializer();
    private Map<Range<Token>, MerkleTree> merkleTrees = new TreeMap<Range<Token>, MerkleTree>(new TokenRangeComparator());
    private IPartitioner partitioner;

    public MerkleTrees(IPartitioner partitioner) {
        this(partitioner, new ArrayList<MerkleTree>());
    }

    private MerkleTrees(IPartitioner partitioner, Collection<MerkleTree> merkleTrees) {
        this.partitioner = partitioner;
        this.addTrees(merkleTrees);
    }

    public Collection<Range<Token>> ranges() {
        return this.merkleTrees.keySet();
    }

    public IPartitioner partitioner() {
        return this.partitioner;
    }

    public void addMerkleTrees(int maxsize, Collection<Range<Token>> ranges) {
        for (Range<Token> range : ranges) {
            this.addMerkleTree(maxsize, range);
        }
    }

    public MerkleTree addMerkleTree(int maxsize, Range<Token> range) {
        return this.addMerkleTree(maxsize, (byte)126, range);
    }

    @VisibleForTesting
    public MerkleTree addMerkleTree(int maxsize, byte hashdepth, Range<Token> range) {
        MerkleTree tree = new MerkleTree(this.partitioner, range, hashdepth, maxsize);
        this.addTree(tree);
        return tree;
    }

    @VisibleForTesting
    public MerkleTree.TreeRange get(Token t) {
        return this.getMerkleTree(t).get(t);
    }

    public void init() {
        for (Range<Token> range : this.merkleTrees.keySet()) {
            this.init(range);
        }
    }

    public void init(Range<Token> range) {
        this.merkleTrees.get(range).init();
    }

    public boolean split(Token t) {
        return this.getMerkleTree(t).split(t);
    }

    @VisibleForTesting
    public void invalidate(Token t) {
        this.getMerkleTree(t).invalidate(t);
    }

    public MerkleTree getMerkleTree(Range<Token> range) {
        return this.merkleTrees.get(range);
    }

    public long size() {
        long size = 0L;
        for (MerkleTree tree : this.merkleTrees.values()) {
            size += tree.size();
        }
        return size;
    }

    @VisibleForTesting
    public void maxsize(Range<Token> range, int maxsize) {
        this.getMerkleTree(range).maxsize(maxsize);
    }

    private MerkleTree getMerkleTree(Token t) {
        for (Range<Token> range : this.merkleTrees.keySet()) {
            if (!range.contains(t)) continue;
            return this.merkleTrees.get(range);
        }
        throw new AssertionError((Object)("Expected tree for token " + t));
    }

    private void addTrees(Collection<MerkleTree> trees) {
        for (MerkleTree tree : trees) {
            this.addTree(tree);
        }
    }

    private void addTree(MerkleTree tree) {
        assert (this.validateNonOverlapping(tree)) : "Range [" + tree.fullRange + "] is intersecting an existing range";
        this.merkleTrees.put(tree.fullRange, tree);
    }

    private boolean validateNonOverlapping(MerkleTree tree) {
        for (Range<Token> range : this.merkleTrees.keySet()) {
            if (!tree.fullRange.intersects(range)) continue;
            return false;
        }
        return true;
    }

    public TreeRangeIterator invalids() {
        return new TreeRangeIterator();
    }

    public void logRowCountPerLeaf(Logger logger) {
        for (MerkleTree tree : this.merkleTrees.values()) {
            tree.histogramOfRowCountPerLeaf().log(logger);
        }
    }

    public void logRowSizePerLeaf(Logger logger) {
        for (MerkleTree tree : this.merkleTrees.values()) {
            tree.histogramOfRowSizePerLeaf().log(logger);
        }
    }

    @VisibleForTesting
    public byte[] hash(Range<Token> range) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean hashed = false;
        try {
            for (Range<Token> rt : this.merkleTrees.keySet()) {
                byte[] bytes;
                if (!rt.intersects(range) || (bytes = this.merkleTrees.get(rt).hash(range)) == null) continue;
                baos.write(bytes);
                hashed = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to append merkle tree hash to result");
        }
        return hashed ? baos.toByteArray() : null;
    }

    @Override
    public Iterator<Map.Entry<Range<Token>, MerkleTree>> iterator() {
        return this.merkleTrees.entrySet().iterator();
    }

    public long rowCount() {
        long totalCount = 0L;
        for (MerkleTree tree : this.merkleTrees.values()) {
            totalCount += tree.rowCount();
        }
        return totalCount;
    }

    public static List<Range<Token>> difference(MerkleTrees ltree, MerkleTrees rtree) {
        ArrayList<Range<Token>> differences = new ArrayList<Range<Token>>();
        for (MerkleTree tree : ltree.merkleTrees.values()) {
            differences.addAll(MerkleTree.difference(tree, rtree.getMerkleTree(tree.fullRange)));
        }
        return differences;
    }

    private static class TokenRangeComparator
    implements Comparator<Range<Token>> {
        private TokenRangeComparator() {
        }

        @Override
        public int compare(Range<Token> rt1, Range<Token> rt2) {
            if (((Token)rt1.left).compareTo(rt2.left) == 0) {
                return 0;
            }
            return rt1.compareTo(rt2);
        }
    }

    public static class MerkleTreesSerializer
    implements IVersionedSerializer<MerkleTrees> {
        @Override
        public void serialize(MerkleTrees trees, DataOutputPlus out, int version) throws IOException {
            out.writeInt(trees.merkleTrees.size());
            for (MerkleTree tree : trees.merkleTrees.values()) {
                MerkleTree.serializer.serialize(tree, out, version);
            }
        }

        @Override
        public MerkleTrees deserialize(DataInputPlus in, int version) throws IOException {
            IPartitioner partitioner = null;
            int nTrees = in.readInt();
            ArrayList<MerkleTree> trees = new ArrayList<MerkleTree>(nTrees);
            if (nTrees > 0) {
                for (int i = 0; i < nTrees; ++i) {
                    MerkleTree tree = MerkleTree.serializer.deserialize(in, version);
                    trees.add(tree);
                    if (partitioner == null) {
                        partitioner = tree.partitioner();
                        continue;
                    }
                    assert (tree.partitioner() == partitioner);
                }
            }
            return new MerkleTrees(partitioner, trees);
        }

        @Override
        public long serializedSize(MerkleTrees trees, int version) {
            assert (trees != null);
            long size = TypeSizes.sizeof(trees.merkleTrees.size());
            for (MerkleTree tree : trees.merkleTrees.values()) {
                size += MerkleTree.serializer.serializedSize(tree, version);
            }
            return size;
        }
    }

    public class TreeRangeIterator
    extends AbstractIterator<MerkleTree.TreeRange>
    implements Iterable<MerkleTree.TreeRange>,
    PeekingIterator<MerkleTree.TreeRange> {
        private final Iterator<MerkleTree> it;
        private MerkleTree.TreeRangeIterator current = null;

        private TreeRangeIterator() {
            this.it = MerkleTrees.this.merkleTrees.values().iterator();
        }

        public MerkleTree.TreeRange computeNext() {
            if (this.current == null || !this.current.hasNext()) {
                return this.nextIterator();
            }
            return (MerkleTree.TreeRange)this.current.next();
        }

        private MerkleTree.TreeRange nextIterator() {
            if (this.it.hasNext()) {
                this.current = this.it.next().invalids();
                return (MerkleTree.TreeRange)this.current.next();
            }
            return (MerkleTree.TreeRange)this.endOfData();
        }

        @Override
        public Iterator<MerkleTree.TreeRange> iterator() {
            return this;
        }
    }
}

