/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamConnectionFactory;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(StreamCoordinator.class);
    private static final DebuggableThreadPoolExecutor streamExecutor = DebuggableThreadPoolExecutor.createWithFixedPoolSize("StreamConnectionEstablisher", FBUtilities.getAvailableProcessors());
    private Map<InetAddress, HostStreamingData> peerSessions = new HashMap<InetAddress, HostStreamingData>();
    private final int connectionsPerHost;
    private StreamConnectionFactory factory;
    private final boolean keepSSTableLevel;
    private final boolean isIncremental;

    public StreamCoordinator(int connectionsPerHost, boolean keepSSTableLevel, boolean isIncremental, StreamConnectionFactory factory) {
        this.connectionsPerHost = connectionsPerHost;
        this.factory = factory;
        this.keepSSTableLevel = keepSSTableLevel;
        this.isIncremental = isIncremental;
    }

    public void setConnectionFactory(StreamConnectionFactory factory) {
        this.factory = factory;
    }

    public synchronized boolean hasActiveSessions() {
        for (HostStreamingData data : this.peerSessions.values()) {
            if (!data.hasActiveSessions()) continue;
            return true;
        }
        return false;
    }

    public synchronized Collection<StreamSession> getAllStreamSessions() {
        ArrayList<StreamSession> results = new ArrayList<StreamSession>();
        for (HostStreamingData data : this.peerSessions.values()) {
            results.addAll(data.getAllStreamSessions());
        }
        return results;
    }

    public boolean isReceiving() {
        return this.connectionsPerHost == 0;
    }

    public void connectAllStreamSessions() {
        for (HostStreamingData data : this.peerSessions.values()) {
            data.connectAllStreamSessions();
        }
    }

    public synchronized Set<InetAddress> getPeers() {
        return new HashSet<InetAddress>(this.peerSessions.keySet());
    }

    public synchronized StreamSession getOrCreateNextSession(InetAddress peer, InetAddress connecting) {
        return this.getOrCreateHostData(peer).getOrCreateNextSession(peer, connecting);
    }

    public synchronized StreamSession getOrCreateSessionById(InetAddress peer, int id, InetAddress connecting) {
        return this.getOrCreateHostData(peer).getOrCreateSessionById(peer, id, connecting);
    }

    public synchronized void updateProgress(ProgressInfo info) {
        this.getHostData(info.peer).updateProgress(info);
    }

    public synchronized void addSessionInfo(SessionInfo session) {
        HostStreamingData data = this.getOrCreateHostData(session.peer);
        data.addSessionInfo(session);
    }

    public synchronized Set<SessionInfo> getAllSessionInfo() {
        HashSet<SessionInfo> result = new HashSet<SessionInfo>();
        for (HostStreamingData data : this.peerSessions.values()) {
            result.addAll(data.getAllSessionInfo());
        }
        return result;
    }

    public synchronized void transferFiles(InetAddress to, Collection<StreamSession.SSTableStreamingSections> sstableDetails) {
        HostStreamingData sessionList = this.getOrCreateHostData(to);
        if (this.connectionsPerHost > 1) {
            List<List<StreamSession.SSTableStreamingSections>> buckets = this.sliceSSTableDetails(sstableDetails);
            for (List<StreamSession.SSTableStreamingSections> subList : buckets) {
                StreamSession session = sessionList.getOrCreateNextSession(to, to);
                session.addTransferFiles(subList);
            }
        } else {
            StreamSession session = sessionList.getOrCreateNextSession(to, to);
            session.addTransferFiles(sstableDetails);
        }
    }

    private List<List<StreamSession.SSTableStreamingSections>> sliceSSTableDetails(Collection<StreamSession.SSTableStreamingSections> sstableDetails) {
        int targetSlices = Math.min(sstableDetails.size(), this.connectionsPerHost);
        int step = Math.round((float)sstableDetails.size() / (float)targetSlices);
        int index = 0;
        ArrayList<List<StreamSession.SSTableStreamingSections>> result = new ArrayList<List<StreamSession.SSTableStreamingSections>>();
        ArrayList<StreamSession.SSTableStreamingSections> slice = null;
        Iterator<StreamSession.SSTableStreamingSections> iter = sstableDetails.iterator();
        while (iter.hasNext()) {
            StreamSession.SSTableStreamingSections streamSession = iter.next();
            if (index % step == 0) {
                slice = new ArrayList<StreamSession.SSTableStreamingSections>();
                result.add(slice);
            }
            slice.add(streamSession);
            ++index;
            iter.remove();
        }
        return result;
    }

    private HostStreamingData getHostData(InetAddress peer) {
        HostStreamingData data = this.peerSessions.get(peer);
        if (data == null) {
            throw new IllegalArgumentException("Unknown peer requested: " + peer);
        }
        return data;
    }

    private HostStreamingData getOrCreateHostData(InetAddress peer) {
        HostStreamingData data = this.peerSessions.get(peer);
        if (data == null) {
            data = new HostStreamingData();
            this.peerSessions.put(peer, data);
        }
        return data;
    }

    @VisibleForTesting
    public static void shutdownAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownAndWait(timeout, unit, streamExecutor);
    }

    private class HostStreamingData {
        private Map<Integer, StreamSession> streamSessions = new HashMap<Integer, StreamSession>();
        private Map<Integer, SessionInfo> sessionInfos = new HashMap<Integer, SessionInfo>();
        private int lastReturned = -1;

        private HostStreamingData() {
        }

        public boolean hasActiveSessions() {
            for (StreamSession session : this.streamSessions.values()) {
                StreamSession.State state = session.state();
                if (state.isFinalState()) continue;
                return true;
            }
            return false;
        }

        public StreamSession getOrCreateNextSession(InetAddress peer, InetAddress connecting) {
            if (this.streamSessions.size() < StreamCoordinator.this.connectionsPerHost) {
                StreamSession session = new StreamSession(peer, connecting, StreamCoordinator.this.factory, this.streamSessions.size(), StreamCoordinator.this.keepSSTableLevel, StreamCoordinator.this.isIncremental);
                this.streamSessions.put(++this.lastReturned, session);
                this.sessionInfos.put(this.lastReturned, session.getSessionInfo());
                return session;
            }
            if (this.lastReturned >= this.streamSessions.size() - 1) {
                this.lastReturned = 0;
            }
            return this.streamSessions.get(this.lastReturned++);
        }

        public void connectAllStreamSessions() {
            for (StreamSession session : this.streamSessions.values()) {
                streamExecutor.execute(new StreamSessionConnector(session));
            }
        }

        public Collection<StreamSession> getAllStreamSessions() {
            return Collections.unmodifiableCollection(this.streamSessions.values());
        }

        public StreamSession getOrCreateSessionById(InetAddress peer, int id, InetAddress connecting) {
            StreamSession session = this.streamSessions.get(id);
            if (session == null) {
                session = new StreamSession(peer, connecting, StreamCoordinator.this.factory, id, StreamCoordinator.this.keepSSTableLevel, StreamCoordinator.this.isIncremental);
                this.streamSessions.put(id, session);
                this.sessionInfos.put(id, session.getSessionInfo());
            }
            return session;
        }

        public void updateProgress(ProgressInfo info) {
            this.sessionInfos.get(info.sessionIndex).updateProgress(info);
        }

        public void addSessionInfo(SessionInfo info) {
            this.sessionInfos.put(info.sessionIndex, info);
        }

        public Collection<SessionInfo> getAllSessionInfo() {
            return this.sessionInfos.values();
        }
    }

    private static class StreamSessionConnector
    implements Runnable {
        private final StreamSession session;

        public StreamSessionConnector(StreamSession session) {
            this.session = session;
        }

        @Override
        public void run() {
            this.session.start();
            logger.info("[Stream #{}, ID#{}] Beginning stream session with {}", new Object[]{this.session.planId(), this.session.sessionIndex(), this.session.peer});
        }
    }
}

