/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32.test;

import java.util.ArrayList;
import org.hyperic.sigar.test.SigarTestCase;
import org.hyperic.sigar.win32.RegistryKey;

public class TestRegistryKey
extends SigarTestCase {
    private static final boolean TEST_WRITE = false;

    public TestRegistryKey(String name) {
        super(name);
    }

    public void testRegistryRead() throws Exception {
        RegistryKey software = RegistryKey.LocalMachine.openSubKey("SOFTWARE");
        String[] keys = software.getSubKeyNames();
        TestRegistryKey.assertTrue((keys.length > 0 ? 1 : 0) != 0);
        software.close();
    }

    public void testHardwareValues() throws Exception {
        RegistryKey hw = RegistryKey.LocalMachine.openSubKey("HARDWARE\\DESCRIPTION\\System");
        try {
            ArrayList values = new ArrayList();
            hw.getMultiStringValue("SystemBiosVersion", values);
            this.assertGtZeroTrace("SystemBiosVersion.size()", values.size());
            this.traceln("SystemBiosVersion=" + values);
        }
        catch (Exception e) {
            // empty catch block
        }
        RegistryKey cpu0 = hw.openSubKey("CentralProcessor\\0");
        String cpu = cpu0.getStringValue("ProcessorNameString");
        this.assertLengthTrace("cpu0", cpu);
        cpu0.close();
        hw.close();
    }

    public void testSoftwareValues() throws Exception {
        RegistryKey ms = RegistryKey.LocalMachine.openSubKey("SOFTWARE\\Microsoft");
        RegistryKey msmq = null;
        try {
            msmq = ms.openSubKey("MSMQ\\Parameters");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (msmq != null) {
            this.traceln("MSMQ...");
            if (msmq.getSubKeyNames().length > 0) {
                try {
                    String build = msmq.getStringValue("CurrentBuild");
                    this.assertLengthTrace("CurrentBuild", build);
                    int id = msmq.getIntValue("SeqID");
                    this.assertGtZeroTrace("SeqID", id);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            msmq.close();
        }
        RegistryKey sql = null;
        try {
            sql = ms.openSubKey("Microsoft SQL Server\\MSSQL.1\\Setup");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sql != null) {
            this.traceln("MsSQL...");
            try {
                String edition = sql.getStringValue("Edition");
                this.assertLengthTrace("Edition", edition);
            }
            catch (Exception e) {
                // empty catch block
            }
            sql.close();
        }
        ms.close();
        String TC = "SOFTWARE\\Apache Software Foundation\\Procrun 2.0\\Tomcat6\\Parameters\\Java";
        try {
            RegistryKey tc = RegistryKey.LocalMachine.openSubKey("SOFTWARE\\Apache Software Foundation\\Procrun 2.0\\Tomcat6\\Parameters\\Java");
            this.traceln("Tomcat6...");
            ArrayList values = new ArrayList();
            tc.getMultiStringValue("Options", values);
            this.assertGtZeroTrace("Options.size()", values.size());
            this.traceln("Options=" + values);
            tc.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testRegistryWrite() throws Exception {
    }
}

