/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain.regionscoped;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ZoneState;

public class AvailabilityZoneDetails {
    @SerializedName(value="zoneName")
    private final String name;
    private final ZoneState state;
    private final Map<String, Map<String, HostService>> hosts;

    @ConstructorProperties(value={"zoneName", "zoneState", "hosts"})
    protected AvailabilityZoneDetails(String name, ZoneState state, Map<String, Map<String, HostService>> hosts) {
        this.name = name;
        this.state = state;
        this.hosts = hosts == null ? ImmutableMap.of() : ImmutableMap.copyOf(hosts);
    }

    public String getName() {
        return this.name;
    }

    public ZoneState getState() {
        return this.state;
    }

    public Map<String, Map<String, HostService>> getHosts() {
        return this.hosts;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.state, this.hosts});
    }

    public boolean equals(Object obj) {
        if (this != obj) {
            return false;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AvailabilityZoneDetails that = (AvailabilityZoneDetails)AvailabilityZoneDetails.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal(this.hosts, that.hosts);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("state", (Object)this.state).add("Hosts", this.hosts);
    }

    public String toString() {
        return this.string().toString();
    }

    public static final class HostService {
        private final boolean available;
        private final boolean active;
        @SerializedName(value="updated_at")
        private final Date updated;

        @ConstructorProperties(value={"available", "active", "updated_at"})
        protected HostService(boolean available, boolean active, Date updated) {
            this.available = available;
            this.active = active;
            this.updated = updated;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public boolean isActive() {
            return this.active;
        }

        public Date getUpdated() {
            return this.updated;
        }

        protected MoreObjects.ToStringHelper string() {
            return MoreObjects.toStringHelper((Object)this).add("available", this.available).add("active", this.active).add("updated", (Object)this.updated);
        }

        public String toString() {
            return this.string().toString();
        }
    }
}

