/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.ansible;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.entity.cm.ansible.AnsibleBashCommands;
import org.apache.brooklyn.entity.cm.ansible.AnsibleConfig;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class AnsiblePlaybookTasks {
    private static final Logger LOG = LoggerFactory.getLogger(AnsiblePlaybookTasks.class);
    private static final String EXTRA_VARS_FILENAME = "extra_vars.yaml";

    public static TaskFactory<?> installAnsible(String ansibleDirectory, boolean force) {
        Entity entity = BrooklynTaskTags.getContextEntity((Task)Tasks.current());
        String installCmd = AnsiblePlaybookTasks.cdAndRun(ansibleDirectory, entity != null ? AnsibleBashCommands.INSTALL_ANSIBLE(entity) : AnsibleBashCommands.INSTALL_ANSIBLE);
        if (!force) {
            installCmd = BashCommands.alternatives((String[])new String[]{"which ansible", installCmd});
        }
        return SshEffectorTasks.ssh((String[])new String[]{installCmd}).summary("install ansible");
    }

    public static TaskFactory<?> installPlaybook(String ansibleDirectory, String playbookName, String playbookUrl) {
        return Tasks.sequential((String)("build ansible playbook file for " + playbookName), (TaskFactory[])new TaskFactory[]{SshEffectorTasks.put((String)(ansibleDirectory + "/" + playbookName + ".yaml")).contents(ResourceUtils.create().getResourceFromUrl(playbookUrl)).createDirectory()});
    }

    protected static String cdAndRun(String targetDirectory, String command) {
        return BashCommands.chain((String[])new String[]{"mkdir -p " + targetDirectory, "cd " + targetDirectory, command});
    }

    @Deprecated
    public static TaskFactory<?> buildPlaybookFile(String ansibleDirectory, String playbook) {
        Entity entity = EffectorTasks.findEntity();
        String yaml = (String)entity.config().get(AnsibleConfig.ANSIBLE_PLAYBOOK_YAML);
        return AnsiblePlaybookTasks.buildPlaybookFile(ansibleDirectory, playbook, yaml);
    }

    public static TaskFactory<?> buildPlaybookFile(String ansibleDirectory, String playbook, String playbookYaml) {
        return Tasks.sequential((String)("build ansible playbook file for " + playbook), (TaskFactory[])new TaskFactory[]{SshEffectorTasks.put((String)(Urls.mergePaths((String[])new String[]{ansibleDirectory}) + "/" + playbook + ".yaml")).contents(playbookYaml).createDirectory()});
    }

    public static SshEffectorTasks.SshEffectorTaskFactory<Integer> runAnsible(String dir, Object extraVars, String playbookName) {
        String cmd = BashCommands.sudo((String)("ansible-playbook " + AnsiblePlaybookTasks.optionalExtraVarsParameter(extraVars) + String.format(" -b %s.yaml", playbookName)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ansible command: {}", (Object)cmd);
        }
        return (SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{AnsiblePlaybookTasks.cdAndRun(dir, cmd)}).summary("run ansible playbook for " + playbookName)).requiringExitCodeZero();
    }

    public static ProcessTaskFactory<Integer> moduleCommand(String module, Object extraVars, String root, String args) {
        String command = "ansible localhost " + AnsiblePlaybookTasks.optionalExtraVarsParameter(extraVars) + " -m '" + module + "' -a '" + args + "'";
        return ((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.sudo((String)BashCommands.chain((String[])new String[]{"cd " + root, command}))}).summary("ad-hoc: " + command)).requiringExitCodeZero();
    }

    public static TaskFactory<?> configureExtraVars(String dir, Object extraVars, boolean force) {
        DumperOptions options = new DumperOptions();
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        Yaml asYaml = new Yaml(options);
        String varsYaml = asYaml.dump(extraVars);
        return SshEffectorTasks.put((String)Urls.mergePaths((String[])new String[]{dir, EXTRA_VARS_FILENAME})).contents(varsYaml).summary("install extra vars").createDirectory();
    }

    private static String optionalExtraVarsParameter(Object extraVars) {
        if (null == extraVars || Strings.isBlank((CharSequence)extraVars.toString())) {
            return "";
        }
        return " --extra-vars \"@extra_vars.yaml\" ";
    }

    public static TaskFactory<?> setUpHostsFile(boolean force) {
        String checkInstalled = !force ? "grep localhost.ansible_connection=local /etc/ansible/hosts || " : "";
        return ((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{checkInstalled + BashCommands.sudo((String)"echo 'localhost ansible_connection=local' | sudo tee /etc/ansible/hosts")}).requiringExitCodeZero()).summary("write hosts file");
    }
}

