/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.domain.Location;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.logging.Logger;

@Singleton
public class EC2SecurityGroupToSecurityGroup
implements Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Supplier<Set<? extends Location>> locations;

    @Inject
    public EC2SecurityGroupToSecurityGroup(@Memoized Supplier<Set<? extends Location>> locations) {
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
    }

    public org.jclouds.compute.domain.SecurityGroup apply(SecurityGroup group) {
        SecurityGroupBuilder builder = new SecurityGroupBuilder();
        Location location = this.findLocationWithId(group.getRegion());
        builder.location(location);
        builder.id(group.getRegion() + "/" + this.idOrName(group));
        builder.providerId(group.getId());
        builder.name(group.getName());
        builder.ipPermissions((Iterable)((Object)group));
        builder.ownerId(group.getOwnerId());
        return builder.build();
    }

    protected String idOrName(SecurityGroup group) {
        return group.getName();
    }

    private Location findLocationWithId(final String locationId) {
        if (locationId == null) {
            return null;
        }
        try {
            Location location = (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new Predicate<Location>(){

                public boolean apply(Location input) {
                    return input.getId().equals(locationId);
                }
            });
            return location;
        }
        catch (NoSuchElementException e) {
            this.logger.debug("couldn't match instance location %s in: %s", new Object[]{locationId, this.locations.get()});
            return null;
        }
    }
}

