/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.usage;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;

public class LocationUsage {
    private final String locationId;
    private final Map<String, String> metadata;
    private final List<LocationEvent> events = Collections.synchronizedList(Lists.newArrayList());

    public LocationUsage(String locationId, Map<String, String> metadata) {
        this.locationId = (String)Preconditions.checkNotNull((Object)locationId, (Object)"locationId");
        this.metadata = (Map)Preconditions.checkNotNull(metadata, (Object)"metadata");
    }

    public String getLocationId() {
        return this.locationId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocationEvent> getEvents() {
        List<LocationEvent> list = this.events;
        synchronized (list) {
            return ImmutableList.copyOf(this.events);
        }
    }

    public void addEvent(LocationEvent event) {
        this.events.add((LocationEvent)Preconditions.checkNotNull((Object)event, (Object)"event"));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("locationId", (Object)this.locationId).toString();
    }

    public static class LocationEvent {
        private final Date date;
        private final Lifecycle state;
        private final String entityId;
        private final String entityType;
        private final String applicationId;
        private final String user;

        public LocationEvent(Lifecycle state, String entityId, String entityType, String applicationId, String user) {
            this(new Date(), state, entityId, entityType, applicationId, user);
        }

        public LocationEvent(Date date, Lifecycle state, String entityId, String entityType, String applicationId, String user) {
            this.date = (Date)Preconditions.checkNotNull((Object)date, (Object)"date");
            this.state = (Lifecycle)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
            this.entityId = (String)Preconditions.checkNotNull((Object)entityId, (Object)"entityId");
            this.entityType = (String)Preconditions.checkNotNull((Object)entityType, (Object)"entityType");
            this.applicationId = applicationId == null ? "" : applicationId;
            this.user = user;
        }

        public Date getDate() {
            return this.date;
        }

        public Lifecycle getState() {
            return this.state;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public String getUser() {
            return this.user;
        }

        public boolean equals(Object other) {
            if (!(other instanceof LocationEvent)) {
                return false;
            }
            LocationEvent o = (LocationEvent)other;
            return Objects.equal((Object)this.date, (Object)o.date) && Objects.equal((Object)((Object)this.state), (Object)((Object)o.state)) && Objects.equal((Object)this.entityId, (Object)o.entityId) && Objects.equal((Object)this.entityType, (Object)o.entityType) && Objects.equal((Object)this.applicationId, (Object)o.applicationId) && Objects.equal((Object)this.user, (Object)o.user);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.date, this.state, this.entityId, this.entityType, this.applicationId, this.user});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("date", (Object)this.date).add("state", (Object)this.state).add("entityId", (Object)this.entityId).add("appId", (Object)this.applicationId).add("user", (Object)this.user).toString();
        }
    }
}

