/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.jclouds.docker.compute.functions.LoginPortForContainer;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.Port;

@Beta
public class PublicPortForContainerPort
implements LoginPortForContainer {
    private final int containerPort;

    public PublicPortForContainerPort(int containerPort) {
        this.containerPort = containerPort;
    }

    public Optional<Integer> apply(Container container) {
        if (container.networkSettings() != null) {
            Map<String, List<Map<String, String>>> ports = container.networkSettings().ports();
            if (ports != null && ports.containsKey(this.containerPort + "/tcp")) {
                return Optional.of((Object)Integer.parseInt((String)((Map)Iterables.getOnlyElement((Iterable)ports.get(this.containerPort + "/tcp"))).get("HostPort")));
            }
        } else if (container.ports() != null) {
            for (Port port : container.ports()) {
                if (port.privatePort() != this.containerPort) continue;
                return Optional.of((Object)port.publicPort());
            }
        }
        return Optional.absent();
    }
}

