/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jclouds.util.Closeables2;

public class ExecChannel
implements Closeable {
    private final OutputStream input;
    private final InputStream output;
    private final InputStream error;
    private final Supplier<Integer> exitStatus;
    private final Closeable closer;

    public ExecChannel(OutputStream input, InputStream output, InputStream error, Supplier<Integer> exitStatus, Closeable closer) {
        this.input = (OutputStream)Preconditions.checkNotNull((Object)input, (Object)"input");
        this.output = (InputStream)Preconditions.checkNotNull((Object)output, (Object)"output");
        this.error = (InputStream)Preconditions.checkNotNull((Object)error, (Object)"error");
        this.exitStatus = (Supplier)Preconditions.checkNotNull(exitStatus, (Object)"exitStatus");
        this.closer = (Closeable)Preconditions.checkNotNull((Object)closer, (Object)"closer");
    }

    public OutputStream getInput() {
        return this.input;
    }

    public InputStream getError() {
        return this.error;
    }

    public InputStream getOutput() {
        return this.output;
    }

    public Supplier<Integer> getExitStatus() {
        return this.exitStatus;
    }

    @Override
    public void close() throws IOException {
        Closeables2.closeQuietly((Closeable)this.input);
        Closeables2.closeQuietly((Closeable)this.output);
        Closeables2.closeQuietly((Closeable)this.error);
        this.closer.close();
    }
}

