/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates.customize;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.KeyValueParser;
import org.jclouds.compute.options.TemplateOptions;

class UserMetadataMapOption
implements TemplateOptionCustomizer {
    UserMetadataMapOption() {
    }

    @Override
    public void apply(TemplateOptions t, ConfigBag props, Object v) {
        if (v != null) {
            t.userMetadata(this.toMapStringString(v));
        }
    }

    private Map<String, String> toMapStringString(Object v) {
        if (v instanceof Map) {
            LinkedHashMap result = Maps.newLinkedHashMap();
            for (Map.Entry entry : ((Map)v).entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                result.put(key, value);
            }
            return result;
        }
        if (v instanceof CharSequence) {
            return KeyValueParser.parseMap((String)v.toString());
        }
        throw new IllegalArgumentException("Invalid type for Map<String,String>: " + v + (v != null ? " of type " + v.getClass() : ""));
    }
}

