/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindVirtualIpPortPairToQueryParams
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input is null") instanceof IpPortPair), (Object)"this binder is only valid for a IpPortPair argument");
        IpPortPair ipPortPair = (IpPortPair)input;
        Preconditions.checkNotNull((Object)ipPortPair.getIp(), (Object)"There must be an IP address defined");
        Preconditions.checkNotNull((Object)ipPortPair.getIp().getIp(), (Object)"There must be an IP address defined in Ip object");
        Preconditions.checkState((ipPortPair.getPort() > 0 ? 1 : 0) != 0, (Object)"The port number must be a positive integer");
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)"virtualip.ip", (Object)ipPortPair.getIp().getIp());
        builder.put((Object)"virtualip.port", (Object)String.valueOf(ipPortPair.getPort()));
        return (R)request.toBuilder().replaceQueryParams((Multimap)builder.build()).build();
    }
}

