/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class XMLHelper {
    XMLHelper() {
    }

    static Document createDocument() throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        XMLHelper.disableExternalEntityParsing(factory);
        return factory.newDocumentBuilder().newDocument();
    }

    private static void disableExternalEntityParsing(DocumentBuilderFactory factory) {
        String[] externalGeneralEntitiesFeatures = new String[]{"http://xml.org/sax/features/external-general-entities", "http://xerces.apache.org/xerces-j/features.html#external-general-entities", "http://xerces.apache.org/xerces2-j/features.html#external-general-entities"};
        XMLHelper.disableFeatures(factory, externalGeneralEntitiesFeatures);
        String[] externalParameterEntitiesFeatures = new String[]{"http://xml.org/sax/features/external-parameter-entities", "http://xerces.apache.org/xerces-j/features.html#external-parameter-entities", "http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities"};
        XMLHelper.disableFeatures(factory, externalParameterEntitiesFeatures);
    }

    private static void disableFeatures(DocumentBuilderFactory factory, String[] features) {
        for (String feature : features) {
            try {
                factory.setFeature(feature, false);
                break;
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
        }
    }

    static void elemWithText(Element node, String name, String text, Document document) {
        XMLHelper.text(XMLHelper.elem(node, name, document), text, document);
    }

    static Element elem(Node node, String name, Document document) {
        Element newNode = document.createElement(name);
        node.appendChild(newNode);
        return newNode;
    }

    private static void text(Element node, String value, Document document) {
        if (value == null) {
            throw new IllegalArgumentException("Illegal null text value");
        }
        node.appendChild(document.createTextNode(value));
    }

    static String asString(Document document) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        serializer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }
}

