/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.docker.domain.Network;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.binders.BindToJsonPayload;

@Consumes(value={"application/json"})
@Path(value="/v{jclouds.api-version}/networks")
public interface NetworkApi {
    @Named(value="networks:list")
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Network> listNetworks();

    @Named(value="network:create")
    @POST
    @Path(value="/create")
    public Network createNetwork(@BinderParam(value=BindToJsonPayload.class) Network var1);

    @Named(value="network:inspect")
    @GET
    @Path(value="/{idOrName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Network inspectNetwork(@PathParam(value="idOrName") String var1);

    @Named(value="network:delete")
    @DELETE
    @Path(value="/{idOrName}")
    public void removeNetwork(@PathParam(value="idOrName") String var1);

    @Named(value="network:connectContainer")
    @POST
    @Path(value="/{idOrName}/connect")
    @Payload(value="%7B\"Container\":\"{containerIdOrName}\"%7D")
    @Headers(keys={"Content-Type"}, values={"application/json"})
    public void connectContainerToNetwork(@PathParam(value="idOrName") String var1, @PayloadParam(value="containerIdOrName") String var2);

    @Named(value="network:disconnectContainer")
    @POST
    @Path(value="/{idOrName}/disconnect")
    @Payload(value="%7B\"Container\":\"{containerIdOrName}\"%7D")
    @Headers(keys={"Content-Type"}, values={"application/json"})
    public void disconnectContainerFromNetwork(@PathParam(value="idOrName") String var1, @PayloadParam(value="containerIdOrName") String var2);
}

