/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.loaders;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.SshKeyPair;
import org.jclouds.logging.Logger;

@Singleton
public class CreateUniqueKeyPair
extends CacheLoader<String, SshKeyPair> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final CloudStackApi client;

    @Inject
    public CreateUniqueKeyPair(CloudStackApi client) {
        this.client = (CloudStackApi)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    public SshKeyPair load(String input) {
        SshKeyPair keyPair = null;
        while (keyPair == null) {
            try {
                keyPair = this.client.getSSHKeyPairApi().createSSHKeyPair(input);
                this.logger.debug(">> creating SSH key pair with name %s", new Object[]{input});
            }
            catch (IllegalStateException e) {
                this.logger.error((Throwable)e, "<< error creating SSH key pair with name %s: ", new Object[]{Throwables.getRootCause((Throwable)e).getMessage()});
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.logger.debug("<< created keyPair(%s)", new Object[]{keyPair.getName()});
        return keyPair;
    }
}

