/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.networking;

import com.google.common.annotations.Beta;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.text.Identifiers;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.features.AWSSecurityGroupApi;
import org.jclouds.aws.ec2.options.CreateSecurityGroupOptions;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.net.util.IpPermissions;

@Beta
public class SecurityGroupDefinition {
    private Callable<String> groupNameFactory = new Callable<String>(){

        @Override
        public String call() {
            return "br-sg-" + Identifiers.makeRandomId((int)8);
        }
    };
    private List<IpPermission> ipPerms = MutableList.of();

    public void createGroupInAwsRegion(ComputeServiceContext computeServiceContext, String region) {
        AWSEC2Api ec2Client = (AWSEC2Api)computeServiceContext.unwrapApi(AWSEC2Api.class);
        String sgId = ((AWSSecurityGroupApi)ec2Client.getSecurityGroupApi().get()).createSecurityGroupInRegionAndReturnId(region, this.getName(), "Brooklyn-managed security group " + this.getName(), new CreateSecurityGroupOptions[0]);
        ((AWSSecurityGroupApi)ec2Client.getSecurityGroupApi().get()).authorizeSecurityGroupIngressInRegion(region, sgId, this.ipPerms);
    }

    public SecurityGroupDefinition allowingInternalPort(int port) {
        return this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(port));
    }

    public SecurityGroupDefinition allowingInternalPorts(int port1, int port2, int ... ports) {
        this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(port1));
        this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(port2));
        for (int port : ports) {
            this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(port));
        }
        return this;
    }

    public SecurityGroupDefinition allowingInternalPortRange(int portRangeStart, int portRangeEnd) {
        return this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).fromPort(portRangeStart).to(portRangeEnd));
    }

    public SecurityGroupDefinition allowingInternalPing() {
        return this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.ICMP));
    }

    public SecurityGroupDefinition allowingPublicPort(int port) {
        return this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(port).originatingFromCidrBlock(Cidr.UNIVERSAL.toString()));
    }

    public SecurityGroupDefinition allowingPublicPorts(int port1, int port2, int ... ports) {
        this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(port1).originatingFromCidrBlock(Cidr.UNIVERSAL.toString()));
        this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(port2).originatingFromCidrBlock(Cidr.UNIVERSAL.toString()));
        for (int port : ports) {
            this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).port(port).originatingFromCidrBlock(Cidr.UNIVERSAL.toString()));
        }
        return this;
    }

    public SecurityGroupDefinition allowingPublicPortRange(int portRangeStart, int portRangeEnd) {
        return this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.TCP).fromPort(portRangeStart).to(portRangeEnd).originatingFromCidrBlock(Cidr.UNIVERSAL.toString()));
    }

    public SecurityGroupDefinition allowingPublicPing() {
        return this.allowing((IpPermission)IpPermissions.permit((IpProtocol)IpProtocol.ICMP).originatingFromCidrBlock(Cidr.UNIVERSAL.toString()));
    }

    public SecurityGroupDefinition allowing(IpPermission permission) {
        this.ipPerms.add(permission);
        return this;
    }

    public SecurityGroupDefinition named(final String name) {
        this.groupNameFactory = new Callable<String>(){

            @Override
            public String call() {
                return name;
            }
        };
        return this;
    }

    public String getName() {
        try {
            return this.groupNameFactory.call();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Iterable<IpPermission> getPermissions() {
        return this.ipPerms;
    }
}

