/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.javax.annotation.Nullable;

public class Host
implements Comparable<Host> {
    private final String id;
    private final AllocationState allocationState;
    private final int averageLoad;
    private final String capabilities;
    private final String clusterId;
    private final String clusterName;
    private final ClusterType clusterType;
    private final String cpuAllocated;
    private final int cpuNumber;
    private final int cpuSpeed;
    private final String cpuUsed;
    private final float cpuWithOverProvisioning;
    private final Date created;
    private final Date disconnected;
    private final long diskSizeAllocated;
    private final long diskSizeTotal;
    private final String events;
    private final boolean hasEnoughCapacity;
    private final Set<String> tags;
    private final String hypervisor;
    private final String ipAddress;
    private final boolean localStorageActive;
    private final String jobId;
    private final AsyncJob.Status jobStatus;
    private final Date lastPinged;
    private final String managementServerId;
    private final long memoryAllocated;
    private final long memoryTotal;
    private final long memoryUsed;
    private final String name;
    private final long networkKbsRead;
    private final long networkKbsWrite;
    private final String osCategoryId;
    private final String osCategoryName;
    private final String podId;
    private final String podName;
    private final Date removed;
    private final State state;
    private final Type type;
    private final String version;
    private final String zoneId;
    private final String zoneName;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHost(this);
    }

    @ConstructorProperties(value={"id", "allocationstate", "averageload", "capabilities", "clusterid", "clustername", "clustertype", "cpuallocated", "cpunumber", "cpuspeed", "cpuused", "cpuwithoverprovisioning", "created", "disconnected", "disksizeallocated", "disksizetotal", "events", "hasenoughcapacity", "hosttags", "hypervisor", "ipaddress", "islocalstorageactive", "jobid", "jobstatus", "lastpinged", "managementserverid", "memoryallocated", "memorytotal", "memoryused", "name", "networkkbsread", "networkkbswrite", "oscategoryid", "oscategoryname", "podid", "podname", "removed", "state", "type", "version", "zoneid", "zonename"})
    protected Host(String id, @Nullable AllocationState allocationState, int averageLoad, @Nullable String capabilities, @Nullable String clusterId, @Nullable String clusterName, @Nullable ClusterType clusterType, @Nullable String cpuAllocated, int cpuNumber, int cpuSpeed, @Nullable String cpuUsed, float cpuWithOverProvisioning, @Nullable Date created, @Nullable Date disconnected, long diskSizeAllocated, long diskSizeTotal, @Nullable String events, boolean hasEnoughCapacity, @Nullable Iterable<String> tags, @Nullable String hypervisor, @Nullable String ipAddress, boolean localStorageActive, @Nullable String jobId, @Nullable AsyncJob.Status jobStatus, @Nullable Date lastPinged, @Nullable String managementServerId, long memoryAllocated, long memoryTotal, long memoryUsed, @Nullable String name, long networkKbsRead, long networkKbsWrite, @Nullable String osCategoryId, @Nullable String osCategoryName, @Nullable String podId, @Nullable String podName, @Nullable Date removed, @Nullable State state, @Nullable Type type, @Nullable String version, @Nullable String zoneId, @Nullable String zoneName) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.allocationState = allocationState;
        this.averageLoad = averageLoad;
        this.capabilities = capabilities;
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.clusterType = clusterType;
        this.cpuAllocated = cpuAllocated;
        this.cpuNumber = cpuNumber;
        this.cpuSpeed = cpuSpeed;
        this.cpuUsed = cpuUsed;
        this.cpuWithOverProvisioning = cpuWithOverProvisioning;
        this.created = created;
        this.disconnected = disconnected;
        this.diskSizeAllocated = diskSizeAllocated;
        this.diskSizeTotal = diskSizeTotal;
        this.events = events;
        this.hasEnoughCapacity = hasEnoughCapacity;
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
        this.hypervisor = hypervisor;
        this.ipAddress = ipAddress;
        this.localStorageActive = localStorageActive;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.lastPinged = lastPinged;
        this.managementServerId = managementServerId;
        this.memoryAllocated = memoryAllocated;
        this.memoryTotal = memoryTotal;
        this.memoryUsed = memoryUsed;
        this.name = name;
        this.networkKbsRead = networkKbsRead;
        this.networkKbsWrite = networkKbsWrite;
        this.osCategoryId = osCategoryId;
        this.osCategoryName = osCategoryName;
        this.podId = podId;
        this.podName = podName;
        this.removed = removed;
        this.state = state;
        this.type = type;
        this.version = version;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public int getAverageLoad() {
        return this.averageLoad;
    }

    @Nullable
    public String getCapabilities() {
        return this.capabilities;
    }

    @Nullable
    public String getClusterId() {
        return this.clusterId;
    }

    @Nullable
    public String getClusterName() {
        return this.clusterName;
    }

    @Nullable
    public ClusterType getClusterType() {
        return this.clusterType;
    }

    @Nullable
    public String getCpuAllocated() {
        return this.cpuAllocated;
    }

    public int getCpuNumber() {
        return this.cpuNumber;
    }

    public int getCpuSpeed() {
        return this.cpuSpeed;
    }

    @Nullable
    public String getCpuUsed() {
        return this.cpuUsed;
    }

    public float getCpuWithOverProvisioning() {
        return this.cpuWithOverProvisioning;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public Date getDisconnected() {
        return this.disconnected;
    }

    public long getDiskSizeAllocated() {
        return this.diskSizeAllocated;
    }

    public long getDiskSizeTotal() {
        return this.diskSizeTotal;
    }

    @Nullable
    public String getEvents() {
        return this.events;
    }

    public boolean isHasEnoughCapacity() {
        return this.hasEnoughCapacity;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    @Nullable
    public String getHypervisor() {
        return this.hypervisor;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isLocalStorageActive() {
        return this.localStorageActive;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public AsyncJob.Status getJobStatus() {
        return this.jobStatus;
    }

    @Nullable
    public Date getLastPinged() {
        return this.lastPinged;
    }

    @Nullable
    public String getManagementServerId() {
        return this.managementServerId;
    }

    public long getMemoryAllocated() {
        return this.memoryAllocated;
    }

    public long getMemoryTotal() {
        return this.memoryTotal;
    }

    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public long getNetworkKbsRead() {
        return this.networkKbsRead;
    }

    public long getNetworkKbsWrite() {
        return this.networkKbsWrite;
    }

    @Nullable
    public String getOsCategoryId() {
        return this.osCategoryId;
    }

    @Nullable
    public String getOsCategoryName() {
        return this.osCategoryName;
    }

    @Nullable
    public String getPodId() {
        return this.podId;
    }

    @Nullable
    public String getPodName() {
        return this.podName;
    }

    @Nullable
    public Date getRemoved() {
        return this.removed;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.allocationState, this.averageLoad, this.capabilities, this.clusterId, this.clusterName, this.clusterType, this.cpuAllocated, this.cpuNumber, this.cpuSpeed, this.cpuUsed, Float.valueOf(this.cpuWithOverProvisioning), this.created, this.disconnected, this.diskSizeAllocated, this.diskSizeTotal, this.events, this.hasEnoughCapacity, this.tags, this.hypervisor, this.ipAddress, this.localStorageActive, this.jobId, this.jobStatus, this.lastPinged, this.managementServerId, this.memoryAllocated, this.memoryTotal, this.memoryUsed, this.name, this.networkKbsRead, this.networkKbsWrite, this.osCategoryId, this.osCategoryName, this.podId, this.podName, this.removed, this.state, this.type, this.version, this.zoneId, this.zoneName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Host that = (Host)Host.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)((Object)this.allocationState), (Object)((Object)that.allocationState)) && Objects.equal((Object)this.averageLoad, (Object)that.averageLoad) && Objects.equal((Object)this.capabilities, (Object)that.capabilities) && Objects.equal((Object)this.clusterId, (Object)that.clusterId) && Objects.equal((Object)this.clusterName, (Object)that.clusterName) && Objects.equal((Object)((Object)this.clusterType), (Object)((Object)that.clusterType)) && Objects.equal((Object)this.cpuAllocated, (Object)that.cpuAllocated) && Objects.equal((Object)this.cpuNumber, (Object)that.cpuNumber) && Objects.equal((Object)this.cpuSpeed, (Object)that.cpuSpeed) && Objects.equal((Object)this.cpuUsed, (Object)that.cpuUsed) && Objects.equal((Object)Float.valueOf(this.cpuWithOverProvisioning), (Object)Float.valueOf(that.cpuWithOverProvisioning)) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.disconnected, (Object)that.disconnected) && Objects.equal((Object)this.diskSizeAllocated, (Object)that.diskSizeAllocated) && Objects.equal((Object)this.diskSizeTotal, (Object)that.diskSizeTotal) && Objects.equal((Object)this.events, (Object)that.events) && Objects.equal((Object)this.hasEnoughCapacity, (Object)that.hasEnoughCapacity) && Objects.equal(this.tags, that.tags) && Objects.equal((Object)this.hypervisor, (Object)that.hypervisor) && Objects.equal((Object)this.ipAddress, (Object)that.ipAddress) && Objects.equal((Object)this.localStorageActive, (Object)that.localStorageActive) && Objects.equal((Object)this.jobId, (Object)that.jobId) && Objects.equal((Object)((Object)this.jobStatus), (Object)((Object)that.jobStatus)) && Objects.equal((Object)this.lastPinged, (Object)that.lastPinged) && Objects.equal((Object)this.managementServerId, (Object)that.managementServerId) && Objects.equal((Object)this.memoryAllocated, (Object)that.memoryAllocated) && Objects.equal((Object)this.memoryTotal, (Object)that.memoryTotal) && Objects.equal((Object)this.memoryUsed, (Object)that.memoryUsed) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.networkKbsRead, (Object)that.networkKbsRead) && Objects.equal((Object)this.networkKbsWrite, (Object)that.networkKbsWrite) && Objects.equal((Object)this.osCategoryId, (Object)that.osCategoryId) && Objects.equal((Object)this.osCategoryName, (Object)that.osCategoryName) && Objects.equal((Object)this.podId, (Object)that.podId) && Objects.equal((Object)this.podName, (Object)that.podName) && Objects.equal((Object)this.removed, (Object)that.removed) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("allocationState", (Object)this.allocationState).add("averageLoad", this.averageLoad).add("capabilities", (Object)this.capabilities).add("clusterId", (Object)this.clusterId).add("clusterName", (Object)this.clusterName).add("clusterType", (Object)this.clusterType).add("cpuAllocated", (Object)this.cpuAllocated).add("cpuNumber", this.cpuNumber).add("cpuSpeed", this.cpuSpeed).add("cpuUsed", (Object)this.cpuUsed).add("cpuWithOverProvisioning", this.cpuWithOverProvisioning).add("created", (Object)this.created).add("disconnected", (Object)this.disconnected).add("diskSizeAllocated", this.diskSizeAllocated).add("diskSizeTotal", this.diskSizeTotal).add("events", (Object)this.events).add("hasEnoughCapacity", this.hasEnoughCapacity).add("tags", this.tags).add("hypervisor", (Object)this.hypervisor).add("ipAddress", (Object)this.ipAddress).add("localStorageActive", this.localStorageActive).add("jobId", (Object)this.jobId).add("jobStatus", (Object)this.jobStatus).add("lastPinged", (Object)this.lastPinged).add("managementServerId", (Object)this.managementServerId).add("memoryAllocated", this.memoryAllocated).add("memoryTotal", this.memoryTotal).add("memoryUsed", this.memoryUsed).add("name", (Object)this.name).add("networkKbsRead", this.networkKbsRead).add("networkKbsWrite", this.networkKbsWrite).add("osCategoryId", (Object)this.osCategoryId).add("osCategoryName", (Object)this.osCategoryName).add("podId", (Object)this.podId).add("podName", (Object)this.podName).add("removed", (Object)this.removed).add("state", (Object)this.state).add("type", (Object)this.type).add("version", (Object)this.version).add("zoneId", (Object)this.zoneId).add("zoneName", (Object)this.zoneName);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Host other) {
        return this.getId().compareTo(other.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected AllocationState allocationState;
        protected int averageLoad;
        protected String capabilities;
        protected String clusterId;
        protected String clusterName;
        protected ClusterType clusterType;
        protected String cpuAllocated;
        protected int cpuNumber;
        protected int cpuSpeed;
        protected String cpuUsed;
        protected float cpuWithOverProvisioning;
        protected Date created;
        protected Date disconnected;
        protected long diskSizeAllocated;
        protected long diskSizeTotal;
        protected String events;
        protected boolean hasEnoughCapacity;
        protected ImmutableSet.Builder<String> tags = ImmutableSet.builder();
        protected String hypervisor;
        protected String ipAddress;
        protected boolean localStorageActive;
        protected String jobId;
        protected AsyncJob.Status jobStatus;
        protected Date lastPinged;
        protected String managementServerId;
        protected long memoryAllocated;
        protected long memoryTotal;
        protected long memoryUsed;
        protected String name;
        protected long networkKbsRead;
        protected long networkKbsWrite;
        protected String osCategoryId;
        protected String osCategoryName;
        protected String podId;
        protected String podName;
        protected Date removed;
        protected State state;
        protected Type type;
        protected String version;
        protected String zoneId;
        protected String zoneName;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this.self();
        }

        public T averageLoad(int averageLoad) {
            this.averageLoad = averageLoad;
            return this.self();
        }

        public T capabilities(String capabilities) {
            this.capabilities = capabilities;
            return this.self();
        }

        public T clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this.self();
        }

        public T clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this.self();
        }

        public T clusterType(ClusterType clusterType) {
            this.clusterType = clusterType;
            return this.self();
        }

        public T cpuAllocated(String cpuAllocated) {
            this.cpuAllocated = cpuAllocated;
            return this.self();
        }

        public T cpuNumber(int cpuNumber) {
            this.cpuNumber = cpuNumber;
            return this.self();
        }

        public T cpuSpeed(int cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
            return this.self();
        }

        public T cpuUsed(String cpuUsed) {
            this.cpuUsed = cpuUsed;
            return this.self();
        }

        public T cpuWithOverProvisioning(float cpuWithOverProvisioning) {
            this.cpuWithOverProvisioning = cpuWithOverProvisioning;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T disconnected(Date disconnected) {
            this.disconnected = disconnected;
            return this.self();
        }

        public T diskSizeAllocated(long diskSizeAllocated) {
            this.diskSizeAllocated = diskSizeAllocated;
            return this.self();
        }

        public T diskSizeTotal(long diskSizeTotal) {
            this.diskSizeTotal = diskSizeTotal;
            return this.self();
        }

        public T events(String events) {
            this.events = events;
            return this.self();
        }

        public T hasEnoughCapacity(boolean hasEnoughCapacity) {
            this.hasEnoughCapacity = hasEnoughCapacity;
            return this.self();
        }

        public T tags(Iterable<String> tags) {
            this.tags = ImmutableSet.builder().addAll(tags);
            return this.self();
        }

        public T tag(String tag) {
            this.tags.add((Object)tag);
            return this.self();
        }

        public T hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this.self();
        }

        public T ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this.self();
        }

        public T localStorageActive(boolean localStorageActive) {
            this.localStorageActive = localStorageActive;
            return this.self();
        }

        public T jobId(String jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public T jobStatus(AsyncJob.Status jobStatus) {
            this.jobStatus = jobStatus;
            return this.self();
        }

        public T lastPinged(Date lastPinged) {
            this.lastPinged = lastPinged;
            return this.self();
        }

        public T managementServerId(String managementServerId) {
            this.managementServerId = managementServerId;
            return this.self();
        }

        public T memoryAllocated(long memoryAllocated) {
            this.memoryAllocated = memoryAllocated;
            return this.self();
        }

        public T memoryTotal(long memoryTotal) {
            this.memoryTotal = memoryTotal;
            return this.self();
        }

        public T memoryUsed(long memoryUsed) {
            this.memoryUsed = memoryUsed;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T networkKbsRead(long networkKbsRead) {
            this.networkKbsRead = networkKbsRead;
            return this.self();
        }

        public T networkKbsWrite(long networkKbsWrite) {
            this.networkKbsWrite = networkKbsWrite;
            return this.self();
        }

        public T osCategoryId(String osCategoryId) {
            this.osCategoryId = osCategoryId;
            return this.self();
        }

        public T osCategoryName(String osCategoryName) {
            this.osCategoryName = osCategoryName;
            return this.self();
        }

        public T podId(String podId) {
            this.podId = podId;
            return this.self();
        }

        public T podName(String podName) {
            this.podName = podName;
            return this.self();
        }

        public T removed(Date removed) {
            this.removed = removed;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T type(Type type) {
            this.type = type;
            return this.self();
        }

        public T version(String version) {
            this.version = version;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public Host build() {
            return new Host(this.id, this.allocationState, this.averageLoad, this.capabilities, this.clusterId, this.clusterName, this.clusterType, this.cpuAllocated, this.cpuNumber, this.cpuSpeed, this.cpuUsed, this.cpuWithOverProvisioning, this.created, this.disconnected, this.diskSizeAllocated, this.diskSizeTotal, this.events, this.hasEnoughCapacity, (Iterable<String>)this.tags.build(), this.hypervisor, this.ipAddress, this.localStorageActive, this.jobId, this.jobStatus, this.lastPinged, this.managementServerId, this.memoryAllocated, this.memoryTotal, this.memoryUsed, this.name, this.networkKbsRead, this.networkKbsWrite, this.osCategoryId, this.osCategoryName, this.podId, this.podName, this.removed, this.state, this.type, this.version, this.zoneId, this.zoneName);
        }

        public T fromHost(Host in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).allocationState(in.getAllocationState())).averageLoad(in.getAverageLoad())).capabilities(in.getCapabilities())).clusterId(in.getClusterId())).clusterName(in.getClusterName())).clusterType(in.getClusterType())).cpuAllocated(in.getCpuAllocated())).cpuNumber(in.getCpuNumber())).cpuSpeed(in.getCpuSpeed())).cpuUsed(in.getCpuUsed())).cpuWithOverProvisioning(in.getCpuWithOverProvisioning())).created(in.getCreated())).disconnected(in.getDisconnected())).diskSizeAllocated(in.getDiskSizeAllocated())).diskSizeTotal(in.getDiskSizeTotal())).events(in.getEvents())).hasEnoughCapacity(in.isHasEnoughCapacity())).tags(in.getTags())).hypervisor(in.getHypervisor())).ipAddress(in.getIpAddress())).localStorageActive(in.isLocalStorageActive())).jobId(in.getJobId())).jobStatus(in.getJobStatus())).lastPinged(in.getLastPinged())).managementServerId(in.getManagementServerId())).memoryAllocated(in.getMemoryAllocated())).memoryTotal(in.getMemoryTotal())).memoryUsed(in.getMemoryUsed())).name(in.getName())).networkKbsRead(in.getNetworkKbsRead())).networkKbsWrite(in.getNetworkKbsWrite())).osCategoryId(in.getOsCategoryId())).osCategoryName(in.getOsCategoryName())).podId(in.getPodId())).podName(in.getPodName())).removed(in.getRemoved())).state(in.getState())).type(in.getType())).version(in.getVersion())).zoneId(in.getZoneId())).zoneName(in.getZoneName());
        }
    }

    public static enum Type {
        STORAGE,
        ROUTING,
        SECONDARY_STORAGE,
        SECONDARY_STORAGE_CMD_EXECUTOR,
        CONSOLE_PROXY,
        EXTERNAL_FIREWALL,
        EXTERNAL_LOAD_BALANCER,
        PXE_SERVER,
        TRAFFIC_MONITOR,
        EXTERNAL_DHCP,
        SECONDARY_STORAGE_VM,
        LOCAL_SECONDARY_STORAGE,
        UNKNOWN;


        public static Type fromValue(String value) {
            try {
                if (value.equals("SecondaryStorageVM")) {
                    return SECONDARY_STORAGE_VM;
                }
                return Type.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            if (this == SECONDARY_STORAGE_VM) {
                return "SecondaryStorageVM";
            }
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum State {
        CONNECTING,
        UP,
        DOWN,
        DISCONNECTED,
        UPDATING,
        PREPARE_FOR_MAINTENANCE,
        ERROR_IN_MAINTENANCE,
        MAINTENANCE,
        ALERT,
        REMOVED,
        REBALANCING,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum ClusterType {
        CLOUD_MANAGED,
        EXTERNAL_MANAGED,
        UNKNOWN;


        public static ClusterType fromValue(String value) {
            try {
                return ClusterType.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

