/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.brooklyn.core.mgmt.internal.CollectionChangeListener;

class ObservableSet<T> {
    private final Set<T> delegate;
    private final Set<CollectionChangeListener<? super T>> listeners = Sets.newCopyOnWriteArraySet();

    public ObservableSet() {
        this(new LinkedHashSet());
    }

    public ObservableSet(Set<T> delegate) {
        this.delegate = (Set)Preconditions.checkNotNull(delegate, (Object)"delegate");
    }

    public void addListener(CollectionChangeListener<? super T> listener) {
        this.listeners.add((CollectionChangeListener<T>)Preconditions.checkNotNull(listener, (Object)"listener"));
    }

    public void removeListener(CollectionChangeListener<? super T> listener) {
        this.listeners.remove(Preconditions.checkNotNull(listener, (Object)"listener"));
    }

    public boolean add(T val) {
        boolean changed = this.delegate.add(val);
        if (changed) {
            for (CollectionChangeListener<T> listener : this.listeners) {
                listener.onItemAdded(val);
            }
        }
        return changed;
    }

    public boolean remove(T val) {
        boolean changed = this.delegate.remove(val);
        if (changed) {
            for (CollectionChangeListener<T> listener : this.listeners) {
                listener.onItemRemoved(val);
            }
        }
        return changed;
    }

    public boolean contains(T val) {
        return this.delegate.contains(val);
    }
}

