/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.controller;

import org.apache.zookeeper.server.controller.ControlCommand;
import org.junit.Assert;
import org.junit.Test;

public class ControlCommandTest {
    @Test
    public void verifyGeneratedUri() {
        Assert.assertEquals((Object)"command/ping", (Object)ControlCommand.createCommandUri((ControlCommand.Action)ControlCommand.Action.PING, null).toLowerCase());
        Assert.assertEquals((Object)"command/ping", (Object)ControlCommand.createCommandUri((ControlCommand.Action)ControlCommand.Action.PING, (String)"").toLowerCase());
        Assert.assertEquals((Object)"command/closeconnection/1234", (Object)ControlCommand.createCommandUri((ControlCommand.Action)ControlCommand.Action.CLOSECONNECTION, (String)"1234").toLowerCase());
    }

    @Test
    public void verifyParseChecksForNull() {
        try {
            ControlCommand.parseUri(null);
            Assert.fail((String)"Should have thrown for null.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void verifyParseChecksForPrefix() {
        try {
            ControlCommand.parseUri((String)"ping");
            Assert.fail((String)"Should have thrown for missing command/ prefix.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void verifyParseCorrectlyFindsCommandWithNoParameter() {
        Assert.assertEquals((Object)ControlCommand.Action.PING, (Object)ControlCommand.parseUri((String)"command/ping").getAction());
    }

    @Test
    public void verifyParseCorrectlyFindsCommandWithParameter() {
        ControlCommand command = ControlCommand.parseUri((String)"command/closeconnection/1234");
        Assert.assertEquals((Object)ControlCommand.Action.CLOSECONNECTION, (Object)command.getAction());
        Assert.assertEquals((Object)"1234", (Object)command.getParameter());
    }

    @Test
    public void verifyParseIllegalCommandWithNoParameter() {
        try {
            ControlCommand.parseUri((String)"pings");
            Assert.fail((String)"Should have thrown for non existing command.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void verifyParseIllegalCommandWithParameter() {
        try {
            ControlCommand.parseUri((String)"command/close_connection/1234");
            Assert.fail((String)"Should have thrown for non existing command.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

