/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.ZKHostnameVerifier;
import org.apache.zookeeper.common.ZKTrustManager;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.burningwave.tools.net.DefaultHostResolver;
import org.burningwave.tools.net.HostResolutionRequestInterceptor;
import org.burningwave.tools.net.HostResolver;
import org.burningwave.tools.net.MappedHostResolver;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKTrustManagerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(ZKTrustManagerTest.class);
    private static KeyPair keyPair;
    private X509ExtendedTrustManager mockX509ExtendedTrustManager;
    private static final String IP_ADDRESS = "127.0.0.1";
    private static final String HOSTNAME = "localhost";
    private Socket mockSocket;

    @BeforeAll
    public static void setupDNSMocks() {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>();
        hostAliases.put(HOSTNAME, IP_ADDRESS);
        HostResolutionRequestInterceptor.INSTANCE.install(new HostResolver[]{new MappedHostResolver(hostAliases), DefaultHostResolver.INSTANCE});
    }

    @AfterAll
    public static void clearDNSMocks() {
        HostResolutionRequestInterceptor.INSTANCE.uninstall();
    }

    @BeforeAll
    public static void createKeyPair() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(4096);
        keyPair = keyPairGenerator.genKeyPair();
    }

    @AfterAll
    public static void removeBouncyCastleProvider() throws Exception {
        Security.removeProvider("BC");
    }

    @BeforeEach
    public void setup() throws Exception {
        this.mockX509ExtendedTrustManager = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
        final InetAddress mockInetAddress = InetAddress.getByName(HOSTNAME);
        this.mockSocket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)this.mockSocket.getInetAddress()).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return mockInetAddress;
            }
        });
    }

    private X509Certificate[] createSelfSignedCertifcateChain(String ipAddress, String hostname) throws Exception {
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, "NOT_LOCALHOST");
        Date notBefore = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(notBefore);
        cal.add(1, 1);
        Date notAfter = cal.getTime();
        BigInteger serialNumber = new BigInteger(128, new Random());
        X509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(nameBuilder.build(), serialNumber, notBefore, notAfter, nameBuilder.build(), keyPair.getPublic()).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
        if (ipAddress != null) {
            generalNames.add(new GeneralName(7, ipAddress));
        }
        if (hostname != null) {
            generalNames.add(new GeneralName(2, hostname));
        }
        if (!generalNames.isEmpty()) {
            certificateBuilder.addExtension(Extension.subjectAlternativeName, true, (ASN1Encodable)new GeneralNames(generalNames.toArray(new GeneralName[0])));
        }
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(keyPair.getPrivate());
        return new X509Certificate[]{new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner))};
    }

    @Test
    public void testServerHostnameVerificationWithHostnameVerificationDisabled() throws Exception {
        VerifiableHostnameVerifier hostnameVerifier = new VerifiableHostnameVerifier();
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, false, false, (ZKHostnameVerifier)hostnameVerifier);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(IP_ADDRESS, HOSTNAME);
        zkTrustManager.checkServerTrusted(certificateChain, null, this.mockSocket);
        ((Socket)Mockito.verify((Object)this.mockSocket, (VerificationMode)Mockito.times((int)0))).getInetAddress();
        Assertions.assertTrue((boolean)hostnameVerifier.hosts.isEmpty());
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testServerHostnameVerificationWithHostnameVerificationDisabledAndClientHostnameVerificationEnabled() throws Exception {
        VerifiableHostnameVerifier hostnameVerifier = new VerifiableHostnameVerifier();
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, false, true, (ZKHostnameVerifier)hostnameVerifier);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(IP_ADDRESS, HOSTNAME);
        zkTrustManager.checkServerTrusted(certificateChain, null, this.mockSocket);
        ((Socket)Mockito.verify((Object)this.mockSocket, (VerificationMode)Mockito.times((int)0))).getInetAddress();
        Assertions.assertTrue((boolean)hostnameVerifier.hosts.isEmpty());
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testServerHostnameVerificationWithIPAddress() throws Exception {
        VerifiableHostnameVerifier hostnameVerifier = new VerifiableHostnameVerifier();
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, true, false, (ZKHostnameVerifier)hostnameVerifier);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(IP_ADDRESS, null);
        zkTrustManager.checkServerTrusted(certificateChain, null, this.mockSocket);
        ((Socket)Mockito.verify((Object)this.mockSocket, (VerificationMode)Mockito.times((int)1))).getInetAddress();
        Assertions.assertEquals(Arrays.asList(IP_ADDRESS), hostnameVerifier.hosts);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testServerHostnameVerificationWithHostname() throws Exception {
        VerifiableHostnameVerifier hostnameVerifier = new VerifiableHostnameVerifier();
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, true, false, (ZKHostnameVerifier)hostnameVerifier);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(null, HOSTNAME);
        zkTrustManager.checkServerTrusted(certificateChain, null, this.mockSocket);
        ((Socket)Mockito.verify((Object)this.mockSocket, (VerificationMode)Mockito.times((int)1))).getInetAddress();
        Assertions.assertEquals(Arrays.asList(IP_ADDRESS, HOSTNAME), hostnameVerifier.hosts);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testClientHostnameVerificationWithHostnameVerificationDisabled() throws Exception {
        VerifiableHostnameVerifier hostnameVerifier = new VerifiableHostnameVerifier();
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, false, true, (ZKHostnameVerifier)hostnameVerifier);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(null, HOSTNAME);
        zkTrustManager.checkClientTrusted(certificateChain, null, this.mockSocket);
        ((Socket)Mockito.verify((Object)this.mockSocket, (VerificationMode)Mockito.times((int)1))).getInetAddress();
        Assertions.assertEquals(Arrays.asList(IP_ADDRESS, HOSTNAME), hostnameVerifier.hosts);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkClientTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testClientHostnameVerificationWithClientHostnameVerificationDisabled() throws Exception {
        VerifiableHostnameVerifier hostnameVerifier = new VerifiableHostnameVerifier();
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, true, false, (ZKHostnameVerifier)hostnameVerifier);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(null, HOSTNAME);
        zkTrustManager.checkClientTrusted(certificateChain, null, this.mockSocket);
        ((Socket)Mockito.verify((Object)this.mockSocket, (VerificationMode)Mockito.times((int)0))).getInetAddress();
        Assertions.assertTrue((boolean)hostnameVerifier.hosts.isEmpty());
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkClientTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testClientHostnameVerificationWithIPAddress() throws Exception {
        VerifiableHostnameVerifier hostnameVerifier = new VerifiableHostnameVerifier();
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, true, true, (ZKHostnameVerifier)hostnameVerifier);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(IP_ADDRESS, null);
        zkTrustManager.checkClientTrusted(certificateChain, null, this.mockSocket);
        ((Socket)Mockito.verify((Object)this.mockSocket, (VerificationMode)Mockito.times((int)1))).getInetAddress();
        Assertions.assertEquals(Arrays.asList(IP_ADDRESS), hostnameVerifier.hosts);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkClientTrusted(certificateChain, null, this.mockSocket);
    }

    @Test
    public void testClientHostnameVerificationWithHostname() throws Exception {
        VerifiableHostnameVerifier hostnameVerifier = new VerifiableHostnameVerifier();
        ZKTrustManager zkTrustManager = new ZKTrustManager(this.mockX509ExtendedTrustManager, true, true, (ZKHostnameVerifier)hostnameVerifier);
        X509Certificate[] certificateChain = this.createSelfSignedCertifcateChain(null, HOSTNAME);
        zkTrustManager.checkClientTrusted(certificateChain, null, this.mockSocket);
        ((Socket)Mockito.verify((Object)this.mockSocket, (VerificationMode)Mockito.times((int)1))).getInetAddress();
        Assertions.assertEquals(Arrays.asList(IP_ADDRESS, HOSTNAME), hostnameVerifier.hosts);
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkClientTrusted(certificateChain, null, this.mockSocket);
    }

    static class VerifiableHostnameVerifier
    extends ZKHostnameVerifier {
        List<String> hosts = new CopyOnWriteArrayList<String>();

        VerifiableHostnameVerifier() {
        }

        public boolean verify(String host, SSLSession session) {
            throw new IllegalArgumentException("not expected to be called by these tests");
        }

        void verify(String host, X509Certificate cert) throws SSLException {
            LOG.info("verifyWithX509Certificate {} {}", (Object)host, (Object)cert);
            this.hosts.add(host);
            super.verify(host, cert);
        }
    }
}

