/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.impl;

import com.scurrilous.circe.StatefulHash;
import com.scurrilous.circe.StatefulLongHash;
import com.scurrilous.circe.StatelessLongHash;
import com.scurrilous.circe.impl.AbstractIncrementalLongHash;
import com.scurrilous.circe.impl.AbstractStatefulHash;
import java.nio.ByteBuffer;

class IncrementalLongStatefulHash
extends AbstractStatefulHash
implements StatefulLongHash {
    final AbstractIncrementalLongHash stateless;
    long current;

    IncrementalLongStatefulHash(AbstractIncrementalLongHash stateless) {
        this.stateless = stateless;
    }

    @Override
    public StatelessLongHash asStateless() {
        return this.stateless;
    }

    @Override
    public String algorithm() {
        return this.stateless.algorithm();
    }

    @Override
    public int length() {
        return this.stateless.length();
    }

    @Override
    public boolean supportsUnsafe() {
        return this.stateless.supportsUnsafe();
    }

    @Override
    public StatefulHash createNew() {
        return new IncrementalLongStatefulHash(this.stateless);
    }

    @Override
    public boolean supportsIncremental() {
        return true;
    }

    @Override
    public void reset() {
        this.current = this.stateless.initial();
    }

    @Override
    public void update(ByteBuffer input) {
        this.current = this.stateless.resume(this.current, input);
    }

    @Override
    public void update(long address, long length) {
        this.current = this.stateless.resume(this.current, address, length);
    }

    @Override
    protected void updateUnchecked(byte[] input, int index, int length) {
        this.current = this.stateless.resumeUnchecked(this.current, input, index, length);
    }

    @Override
    public int getInt() {
        return (int)this.current;
    }

    @Override
    public long getLong() {
        return this.current;
    }
}

