/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CheckedOutputStream;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.PurgeTxnLog;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.zookeeper.server.persistence.FileSnap;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.SnapStream;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeTxnTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeTxnTest.class);
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final long OP_TIMEOUT_IN_MILLIS = 120000L;
    private File tmpDir;

    @BeforeEach
    public void setUp() throws Exception {
        this.tmpDir = ClientBase.createTmpDir();
    }

    @AfterEach
    public void teardown() {
        if (null != this.tmpDir) {
            ClientBase.recursiveDelete(this.tmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurge() throws Exception {
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L), (String)"waiting for server being up ");
        try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
            for (int i = 0; i < 2000; ++i) {
                zk.create("/invalidsnap-" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        f.shutdown();
        zks.getTxnLogFactory().close();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L), (String)"waiting for server to shutdown");
        PurgeTxnLog.purge((File)this.tmpDir, (File)this.tmpDir, (int)3);
        FileTxnSnapLog snaplog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        List listLogs = snaplog.findNValidSnapshots(4);
        int numSnaps = 0;
        for (File ff : listLogs) {
            if (!ff.getName().startsWith("snapshot")) continue;
            ++numSnaps;
        }
        Assertions.assertTrue((numSnaps == 3 ? 1 : 0) != 0, (String)"exactly 3 snapshots ");
        snaplog.close();
        zks.shutdown();
    }

    @Test
    public void testPurgeWhenLogRollingInProgress() throws Exception {
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)30);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L), (String)"waiting for server being up ");
        ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);
        final CountDownLatch doPurge = new CountDownLatch(1);
        final CountDownLatch purgeFinished = new CountDownLatch(1);
        final AtomicBoolean opFailed = new AtomicBoolean(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    doPurge.await(60000L, TimeUnit.MILLISECONDS);
                    PurgeTxnLog.purge((File)PurgeTxnTest.this.tmpDir, (File)PurgeTxnTest.this.tmpDir, (int)3);
                }
                catch (IOException ioe) {
                    LOG.error("Exception when purge", (Throwable)ioe);
                    opFailed.set(true);
                }
                catch (InterruptedException ie) {
                    LOG.error("Exception when purge", (Throwable)ie);
                    opFailed.set(true);
                }
                finally {
                    purgeFinished.countDown();
                }
            }
        }.start();
        int thCount = 3;
        List<String> znodes = this.manyClientOps(zk, doPurge, 3, "/invalidsnap");
        Assertions.assertTrue((boolean)purgeFinished.await(120000L, TimeUnit.MILLISECONDS), (String)"Purging is not finished!");
        Assertions.assertFalse((boolean)opFailed.get(), (String)"Purging failed!");
        for (String znode : znodes) {
            try {
                zk.getData(znode, false, null);
            }
            catch (Exception ke) {
                LOG.error("Unexpected exception when visiting znode!", (Throwable)ke);
                Assertions.fail((String)"Unexpected exception when visiting znode!");
            }
        }
        zk.close();
        f.shutdown();
        zks.shutdown();
        zks.getTxnLogFactory().close();
    }

    @Test
    public void testFindNValidSnapshots() throws Exception {
        int nRecentSnap = 4;
        int nRecentCount = 30;
        int offset = 0;
        File version2 = new File(this.tmpDir.toString(), "version-2");
        Assertions.assertTrue((boolean)version2.mkdir(), (String)("Failed to create version_2 dir:" + version2.toString()));
        FileTxnSnapLog txnLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        List foundSnaps = txnLog.findNValidSnapshots(1);
        Assertions.assertEquals((int)0, (int)foundSnaps.size());
        ArrayList<File> expectedNRecentSnapFiles = new ArrayList<File>();
        int counter = offset + 2 * nRecentCount;
        for (int i = 0; i < nRecentCount; ++i) {
            File logFile = new File(version2 + "/log." + Long.toHexString(--counter));
            Assertions.assertTrue((boolean)logFile.createNewFile(), (String)("Failed to create log File:" + logFile.toString()));
            File snapFile = new File(version2 + "/snapshot." + Long.toHexString(--counter));
            Assertions.assertTrue((boolean)snapFile.createNewFile(), (String)("Failed to create snap File:" + snapFile.toString()));
            this.makeValidSnapshot(snapFile);
            if (i >= nRecentSnap) continue;
            expectedNRecentSnapFiles.add(snapFile);
        }
        List nRecentValidSnapFiles = txnLog.findNValidSnapshots(nRecentSnap);
        Assertions.assertEquals((int)4, (int)nRecentValidSnapFiles.size(), (String)"exactly 4 snapshots ");
        expectedNRecentSnapFiles.removeAll(nRecentValidSnapFiles);
        Assertions.assertEquals((int)0, (int)expectedNRecentSnapFiles.size(), (String)"Didn't get the recent snap files");
        nRecentValidSnapFiles = txnLog.findNValidSnapshots(nRecentCount + 5);
        Assertions.assertEquals((int)nRecentCount, (int)nRecentValidSnapFiles.size());
        for (File f : nRecentValidSnapFiles) {
            Assertions.assertTrue((Util.getZxidFromName((String)f.getName(), (String)"snapshot") != -1L ? 1 : 0) != 0, (String)("findNValidSnapshots() returned a non-snapshot: " + f.getPath()));
        }
        txnLog.close();
    }

    @Test
    public void testSnapFilesGreaterThanToRetain() throws Exception {
        int nRecentCount = 4;
        int fileAboveRecentCount = 4;
        int fileToPurgeCount = 2;
        AtomicInteger offset = new AtomicInteger(0);
        File version2 = new File(this.tmpDir.toString(), "version-2");
        Assertions.assertTrue((boolean)version2.mkdir(), (String)("Failed to create version_2 dir:" + version2.toString()));
        ArrayList<File> snapsToPurge = new ArrayList<File>();
        ArrayList<File> logsToPurge = new ArrayList<File>();
        ArrayList<File> snaps = new ArrayList<File>();
        ArrayList<File> logs = new ArrayList<File>();
        ArrayList<File> snapsAboveRecentFiles = new ArrayList<File>();
        ArrayList<File> logsAboveRecentFiles = new ArrayList<File>();
        this.createDataDirFiles(offset, fileToPurgeCount, false, version2, snapsToPurge, logsToPurge);
        this.createDataDirFiles(offset, nRecentCount, false, version2, snaps, logs);
        logs.add((File)logsToPurge.remove(0));
        this.createDataDirFiles(offset, fileAboveRecentCount, false, version2, snapsAboveRecentFiles, logsAboveRecentFiles);
        logsToPurge.remove(0);
        FileTxnSnapLog txnLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        PurgeTxnLog.purgeOlderSnapshots((FileTxnSnapLog)txnLog, (File)((File)snaps.get(snaps.size() - 1)));
        txnLog.close();
        this.verifyFilesAfterPurge(snapsToPurge, false);
        this.verifyFilesAfterPurge(logsToPurge, false);
        this.verifyFilesAfterPurge(snaps, true);
        this.verifyFilesAfterPurge(logs, true);
        this.verifyFilesAfterPurge(snapsAboveRecentFiles, true);
        this.verifyFilesAfterPurge(logsAboveRecentFiles, true);
    }

    @Test
    public void testSnapFilesEqualsToRetain() throws Exception {
        this.internalTestSnapFilesEqualsToRetain(false);
    }

    @Test
    public void testSnapFilesEqualsToRetainWithPrecedingLog() throws Exception {
        this.internalTestSnapFilesEqualsToRetain(true);
    }

    public void internalTestSnapFilesEqualsToRetain(boolean testWithPrecedingLogFile) throws Exception {
        int nRecentCount = 3;
        AtomicInteger offset = new AtomicInteger(0);
        File version2 = new File(this.tmpDir.toString(), "version-2");
        Assertions.assertTrue((boolean)version2.mkdir(), (String)("Failed to create version_2 dir:" + version2.toString()));
        ArrayList<File> snaps = new ArrayList<File>();
        ArrayList<File> logs = new ArrayList<File>();
        this.createDataDirFiles(offset, nRecentCount, testWithPrecedingLogFile, version2, snaps, logs);
        FileTxnSnapLog txnLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        PurgeTxnLog.purgeOlderSnapshots((FileTxnSnapLog)txnLog, (File)((File)snaps.get(snaps.size() - 1)));
        txnLog.close();
        this.verifyFilesAfterPurge(snaps, true);
        this.verifyFilesAfterPurge(logs, true);
    }

    @Test
    public void testSnapFilesLessThanToRetain() throws Exception {
        int nRecentCount = 4;
        int fileToPurgeCount = 2;
        AtomicInteger offset = new AtomicInteger(0);
        File version2 = new File(this.tmpDir.toString(), "version-2");
        Assertions.assertTrue((boolean)version2.mkdir(), (String)("Failed to create version_2 dir:" + version2.toString()));
        ArrayList<File> snapsToPurge = new ArrayList<File>();
        ArrayList<File> logsToPurge = new ArrayList<File>();
        ArrayList<File> snaps = new ArrayList<File>();
        ArrayList<File> logs = new ArrayList<File>();
        this.createDataDirFiles(offset, fileToPurgeCount, false, version2, snapsToPurge, logsToPurge);
        this.createDataDirFiles(offset, nRecentCount, false, version2, snaps, logs);
        logs.add((File)logsToPurge.remove(0));
        logsToPurge.remove(0);
        FileTxnSnapLog txnLog = new FileTxnSnapLog(this.tmpDir, this.tmpDir);
        PurgeTxnLog.purgeOlderSnapshots((FileTxnSnapLog)txnLog, (File)((File)snaps.get(snaps.size() - 1)));
        txnLog.close();
        this.verifyFilesAfterPurge(snapsToPurge, false);
        this.verifyFilesAfterPurge(logsToPurge, false);
        this.verifyFilesAfterPurge(snaps, true);
        this.verifyFilesAfterPurge(logs, true);
    }

    @Test
    public void testPurgeTxnLogWithDataDir() throws Exception {
        File dataDir = new File(this.tmpDir, "dataDir");
        File dataLogDir = new File(this.tmpDir, "dataLogDir");
        File dataDirVersion2 = new File(dataDir, "version-2");
        dataDirVersion2.mkdirs();
        File dataLogDirVersion2 = new File(dataLogDir, "version-2");
        dataLogDirVersion2.mkdirs();
        int totalFiles = 20;
        for (int i = 0; i < totalFiles; ++i) {
            File logFile = new File(dataLogDirVersion2, "log." + Long.toHexString(i));
            logFile.createNewFile();
            File snapFile = new File(dataDirVersion2, "snapshot." + Long.toHexString(i));
            snapFile.createNewFile();
            this.makeValidSnapshot(snapFile);
        }
        int numberOfSnapFilesToKeep = 10;
        String[] args = new String[]{dataLogDir.getAbsolutePath(), dataDir.getAbsolutePath(), "-n", Integer.toString(numberOfSnapFilesToKeep)};
        PurgeTxnLog.main((String[])args);
        Assertions.assertEquals((int)numberOfSnapFilesToKeep, (int)dataDirVersion2.listFiles().length);
        Assertions.assertEquals((int)numberOfSnapFilesToKeep, (int)dataLogDirVersion2.listFiles().length);
    }

    @Test
    public void testPurgeTxnLogWithoutDataDir() throws Exception {
        File dataDir = new File(this.tmpDir, "dataDir");
        File dataLogDir = new File(this.tmpDir, "dataLogDir");
        File dataDirVersion2 = new File(dataDir, "version-2");
        dataDirVersion2.mkdirs();
        File dataLogDirVersion2 = new File(dataLogDir, "version-2");
        dataLogDirVersion2.mkdirs();
        int totalFiles = 20;
        for (int i = 0; i < totalFiles; ++i) {
            File logFile = new File(dataLogDirVersion2, "log." + Long.toHexString(i));
            logFile.createNewFile();
            File snapFile = new File(dataLogDirVersion2, "snapshot." + Long.toHexString(i));
            snapFile.createNewFile();
            this.makeValidSnapshot(snapFile);
        }
        int numberOfSnapFilesToKeep = 10;
        String[] args = new String[]{dataLogDir.getAbsolutePath(), "-n", Integer.toString(numberOfSnapFilesToKeep)};
        PurgeTxnLog.main((String[])args);
        Assertions.assertEquals((int)(numberOfSnapFilesToKeep * 2), (int)dataLogDirVersion2.listFiles().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgeDoesNotDeleteOverlappingLogFile() throws Exception {
        int SNAP_RETAIN_COUNT = 3;
        int NUM_ZNODES_PER_SNAPSHOT = 100;
        SyncRequestProcessor.setSnapCount((int)3000);
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L), (String)"waiting for server being up ");
        int unique = 0;
        try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
            for (int snapshotCount = 0; snapshotCount < 3; ++snapshotCount) {
                int i = 0;
                while (i < 100) {
                    zk.create("/snap-" + unique, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    ++i;
                    ++unique;
                }
                zks.takeSnapshot();
            }
            int i = 0;
            while (i < 100) {
                zk.create("/snap-" + unique, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                ++i;
                ++unique;
            }
        }
        f.shutdown();
        zks.getTxnLogFactory().close();
        zks.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L), (String)"waiting for server to shutdown");
        PurgeTxnLog.purge((File)this.tmpDir, (File)this.tmpDir, (int)3);
        zks = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        zk = ClientBase.createZKClient(HOSTPORT);
        String lastZnode = "/snap-" + (unique - 1);
        Stat stat = zk.exists(lastZnode, false);
        Assertions.assertNotNull((Object)stat, (String)("Last znode does not exist: " + lastZnode));
        f.shutdown();
        zks.getTxnLogFactory().close();
        zks.shutdown();
    }

    @Test
    public void testPurgeTxnLogWhenRecentSnapshotsAreAllInvalid() throws Exception {
        File dataDir = new File(this.tmpDir, "dataDir");
        File dataLogDir = new File(this.tmpDir, "dataLogDir");
        File dataDirVersion2 = new File(dataDir, "version-2");
        dataDirVersion2.mkdirs();
        File dataLogDirVersion2 = new File(dataLogDir, "version-2");
        dataLogDirVersion2.mkdirs();
        int totalFiles = 10;
        int numberOfSnapFilesToKeep = 3;
        for (int i = 0; i < totalFiles; ++i) {
            File logFile = new File(dataLogDirVersion2, "log." + Long.toHexString(i));
            logFile.createNewFile();
            File snapFile = new File(dataDirVersion2, "snapshot." + Long.toHexString(i));
            snapFile.createNewFile();
            if (i < totalFiles - numberOfSnapFilesToKeep) {
                this.makeValidSnapshot(snapFile);
                continue;
            }
            this.makeInvalidSnapshot(snapFile);
        }
        String[] args = new String[]{dataLogDir.getAbsolutePath(), dataDir.getAbsolutePath(), "-n", Integer.toString(numberOfSnapFilesToKeep)};
        PurgeTxnLog.main((String[])args);
        Assertions.assertEquals((int)(numberOfSnapFilesToKeep + numberOfSnapFilesToKeep), (int)dataDirVersion2.listFiles().length);
        Assertions.assertEquals((int)(numberOfSnapFilesToKeep + numberOfSnapFilesToKeep), (int)dataLogDirVersion2.listFiles().length);
    }

    private File createDataDirLogFile(File version_2, int Zxid) throws IOException {
        File logFile = new File(version_2 + "/log." + Long.toHexString(Zxid));
        Assertions.assertTrue((boolean)logFile.createNewFile(), (String)("Failed to create log File:" + logFile.toString()));
        return logFile;
    }

    private void createDataDirFiles(AtomicInteger offset, int limit, boolean createPrecedingLogFile, File version_2, List<File> snaps, List<File> logs) throws IOException {
        int counter = offset.get() + 2 * limit;
        if (createPrecedingLogFile) {
            ++counter;
        }
        offset.set(counter);
        for (int i = 0; i < limit; ++i) {
            logs.add(this.createDataDirLogFile(version_2, --counter));
            File snapFile = new File(version_2 + "/snapshot." + Long.toHexString(--counter));
            Assertions.assertTrue((boolean)snapFile.createNewFile(), (String)("Failed to create snap File:" + snapFile.toString()));
            snaps.add(snapFile);
        }
        if (createPrecedingLogFile) {
            logs.add(this.createDataDirLogFile(version_2, --counter));
        }
    }

    private void verifyFilesAfterPurge(List<File> logs, boolean exists) {
        for (File file : logs) {
            Assertions.assertEquals((Object)exists, (Object)file.exists(), (String)("After purging, file " + file));
        }
    }

    private List<String> manyClientOps(ZooKeeper zk, CountDownLatch doPurge, int thCount, String prefix) {
        Thread[] ths = new Thread[thCount];
        List<String> znodes = Collections.synchronizedList(new ArrayList());
        CountDownLatch finished = new CountDownLatch(thCount);
        AtomicReference exception = new AtomicReference();
        for (int indx = 0; indx < thCount; ++indx) {
            Thread th;
            String myprefix = prefix + "-" + indx;
            ths[indx] = th = new Thread(() -> {
                for (int i = 0; i < 750; ++i) {
                    try {
                        String mynode = myprefix + "-" + i;
                        znodes.add(mynode);
                        zk.create(mynode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected exception during ZkClient ops", (Throwable)e);
                        exception.set(e);
                    }
                    if (i != 200) continue;
                    doPurge.countDown();
                }
                finished.countDown();
            });
        }
        for (Thread thread : ths) {
            thread.start();
        }
        try {
            boolean operationsFinishedSuccessfully = finished.await(120000L, TimeUnit.MILLISECONDS);
            if (exception.get() != null) {
                LOG.error("unexpected exception during running ZkClient ops:", (Throwable)exception.get());
                Assertions.fail((String)"unexpected exception during running ZkClient ops, see in the logs above");
            }
            Assertions.assertTrue((boolean)operationsFinishedSuccessfully, (String)"ZkClient ops not finished in time!");
        }
        catch (InterruptedException ie) {
            LOG.error("Unexpected exception", (Throwable)ie);
            Assertions.fail((String)"Unexpected exception occurred!");
        }
        return znodes;
    }

    private void makeValidSnapshot(File snapFile) throws IOException {
        SnapStream.setStreamMode((SnapStream.StreamMode)SnapStream.StreamMode.CHECKED);
        CheckedOutputStream os = SnapStream.getOutputStream((File)snapFile, (boolean)true);
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive((OutputStream)os);
        FileHeader header = new FileHeader(FileSnap.SNAP_MAGIC, 2, 1L);
        header.serialize((OutputArchive)oa, "fileheader");
        SnapStream.sealStream((CheckedOutputStream)os, (OutputArchive)oa);
        os.flush();
        os.close();
        Assertions.assertTrue((boolean)SnapStream.isValidSnapshot((File)snapFile));
    }

    private void makeInvalidSnapshot(File snapFile) throws IOException {
        SnapStream.setStreamMode((SnapStream.StreamMode)SnapStream.StreamMode.CHECKED);
        CheckedOutputStream os = SnapStream.getOutputStream((File)snapFile, (boolean)true);
        ((OutputStream)os).write(1);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        Assertions.assertFalse((boolean)SnapStream.isValidSnapshot((File)snapFile));
    }
}

