/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.bookie.storage.ldb.WriteCache;
import org.apache.bookkeeper.util.collections.ConcurrentLongLongPairHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCache
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ReadCache.class);
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x40000000;
    private final List<ByteBuf> cacheSegments;
    private final List<ConcurrentLongLongPairHashMap> cacheIndexes;
    private int currentSegmentIdx;
    private final AtomicInteger currentSegmentOffset = new AtomicInteger(0);
    private final int segmentSize;
    private ByteBufAllocator allocator;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ReadCache(ByteBufAllocator allocator, long maxCacheSize) {
        this(allocator, maxCacheSize, 0x40000000);
    }

    public ReadCache(ByteBufAllocator allocator, long maxCacheSize, int maxSegmentSize) {
        this.allocator = allocator;
        int segmentsCount = Math.max(2, (int)(maxCacheSize / (long)maxSegmentSize));
        this.segmentSize = (int)(maxCacheSize / (long)segmentsCount);
        this.cacheSegments = new ArrayList<ByteBuf>();
        this.cacheIndexes = new ArrayList<ConcurrentLongLongPairHashMap>();
        for (int i = 0; i < segmentsCount; ++i) {
            this.cacheSegments.add(Unpooled.directBuffer((int)this.segmentSize, (int)this.segmentSize));
            ConcurrentLongLongPairHashMap concurrentLongLongPairHashMap = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(4096).concurrencyLevel(2 * Runtime.getRuntime().availableProcessors()).build();
            this.cacheIndexes.add(concurrentLongLongPairHashMap);
        }
    }

    @Override
    public void close() {
        this.cacheSegments.forEach(ReferenceCounted::release);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long ledgerId, long entryId, ByteBuf entry) {
        int offset;
        int alignedSize;
        int entrySize;
        block10: {
            entrySize = entry.readableBytes();
            alignedSize = WriteCache.align64(entrySize);
            this.lock.readLock().lock();
            try {
                if (entrySize > this.segmentSize) {
                    log.warn("entrySize {} > segmentSize {}, skip update read cache!", (Object)entrySize, (Object)this.segmentSize);
                    return;
                }
                offset = this.currentSegmentOffset.getAndAdd(alignedSize);
                if (offset + entrySize > this.segmentSize) {
                    break block10;
                }
                this.cacheSegments.get(this.currentSegmentIdx).setBytes(offset, entry, entry.readerIndex(), entry.readableBytes());
                this.cacheIndexes.get(this.currentSegmentIdx).put(ledgerId, entryId, offset, entrySize);
                return;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        this.lock.writeLock().lock();
        try {
            offset = this.currentSegmentOffset.getAndAdd(entrySize);
            if (offset + entrySize > this.segmentSize) {
                this.currentSegmentIdx = (this.currentSegmentIdx + 1) % this.cacheSegments.size();
                this.currentSegmentOffset.set(alignedSize);
                this.cacheIndexes.get(this.currentSegmentIdx).clear();
                offset = 0;
            }
            this.cacheSegments.get(this.currentSegmentIdx).setBytes(offset, entry, entry.readerIndex(), entry.readableBytes());
            this.cacheIndexes.get(this.currentSegmentIdx).put(ledgerId, entryId, offset, entrySize);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf get(long ledgerId, long entryId) {
        this.lock.readLock().lock();
        try {
            int size = this.cacheSegments.size();
            for (int i = 0; i < size; ++i) {
                int segmentIdx = (this.currentSegmentIdx + (size - i)) % size;
                ConcurrentLongLongPairHashMap.LongPair res = this.cacheIndexes.get(segmentIdx).get(ledgerId, entryId);
                if (res == null) continue;
                int entryOffset = (int)res.first;
                int entryLen = (int)res.second;
                ByteBuf entry = this.allocator.buffer(entryLen, entryLen);
                entry.writeBytes(this.cacheSegments.get(segmentIdx), entryOffset, entryLen);
                ByteBuf byteBuf = entry;
                return byteBuf;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntry(long ledgerId, long entryId) {
        this.lock.readLock().lock();
        try {
            int size = this.cacheSegments.size();
            for (int i = 0; i < size; ++i) {
                int segmentIdx = (this.currentSegmentIdx + (size - i)) % size;
                ConcurrentLongLongPairHashMap.LongPair res = this.cacheIndexes.get(segmentIdx).get(ledgerId, entryId);
                if (res == null) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        this.lock.readLock().lock();
        try {
            long size = 0L;
            for (int i = 0; i < this.cacheIndexes.size(); ++i) {
                if (i == this.currentSegmentIdx) {
                    size += (long)this.currentSegmentOffset.get();
                    continue;
                }
                if (this.cacheIndexes.get(i).isEmpty()) continue;
                size += (long)this.segmentSize;
            }
            long l = size;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        this.lock.readLock().lock();
        try {
            long count = 0L;
            for (int i = 0; i < this.cacheIndexes.size(); ++i) {
                count += this.cacheIndexes.get(i).size();
            }
            long l = count;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

