/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.HandleFactory;
import org.apache.bookkeeper.bookie.LedgerDescriptor;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.util.collections.ConcurrentLongHashMap;

class HandleFactoryImpl
implements HandleFactory,
LedgerStorage.LedgerDeletionListener {
    private final ConcurrentLongHashMap<LedgerDescriptor> ledgers;
    private final ConcurrentLongHashMap<LedgerDescriptor> readOnlyLedgers;
    final LedgerStorage ledgerStorage;

    HandleFactoryImpl(LedgerStorage ledgerStorage) {
        this.ledgerStorage = ledgerStorage;
        this.ledgers = ConcurrentLongHashMap.newBuilder().build();
        this.readOnlyLedgers = ConcurrentLongHashMap.newBuilder().build();
        ledgerStorage.registerLedgerDeletionListener(this);
    }

    @Override
    public LedgerDescriptor getHandle(long ledgerId, byte[] masterKey) throws IOException, BookieException {
        LedgerDescriptor handle = this.ledgers.get(ledgerId);
        if (handle == null) {
            handle = LedgerDescriptor.create(masterKey, ledgerId, this.ledgerStorage);
            this.ledgers.putIfAbsent(ledgerId, handle);
        }
        handle.checkAccess(masterKey);
        return handle;
    }

    @Override
    public LedgerDescriptor getReadOnlyHandle(long ledgerId) throws IOException, Bookie.NoLedgerException {
        LedgerDescriptor handle = this.readOnlyLedgers.get(ledgerId);
        if (handle == null) {
            handle = LedgerDescriptor.createReadOnly(ledgerId, this.ledgerStorage);
            this.readOnlyLedgers.putIfAbsent(ledgerId, handle);
        }
        return handle;
    }

    @Override
    public void ledgerDeleted(long ledgerId) {
        this.ledgers.remove(ledgerId);
        this.readOnlyLedgers.remove(ledgerId);
    }
}

