/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.jshell;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.DiagList;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.JShell;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Key;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.OuterWrap;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Util;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Wrap;

public abstract class Snippet {
    private final Key key;
    private final String source;
    private final Wrap guts;
    final String unitName;
    private final SubKind subkind;
    private int seq;
    private String className;
    private String id;
    private OuterWrap outer;
    private Status status;
    private List<String> unresolved;
    private DiagList diagnostics;

    Snippet(Key key, String userSource, Wrap guts, String unitName, SubKind subkind) {
        this.key = key;
        this.source = userSource;
        this.guts = guts;
        this.unitName = unitName;
        this.subkind = subkind;
        this.status = Status.NONEXISTENT;
        this.setSequenceNumber(0);
    }

    public String id() {
        return this.id;
    }

    public Kind kind() {
        return this.subkind.kind();
    }

    public SubKind subKind() {
        return this.subkind;
    }

    public String source() {
        return this.source;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Snippet:");
        if (this.key() != null) {
            sb.append(this.key().toString());
        }
        sb.append('-');
        sb.append(this.source);
        return sb.toString();
    }

    String name() {
        return this.unitName;
    }

    Key key() {
        return this.key;
    }

    List<String> unresolved() {
        return Collections.unmodifiableList(this.unresolved);
    }

    DiagList diagnostics() {
        return this.diagnostics;
    }

    Wrap corralled() {
        return null;
    }

    Collection<String> declareReferences() {
        return null;
    }

    Collection<String> bodyReferences() {
        return null;
    }

    String importLine(JShell state) {
        return "";
    }

    void setId(String id) {
        this.id = id;
    }

    final void setSequenceNumber(int seq) {
        this.seq = seq;
        this.className = "$REPL" + this.key().index() + Util.asLetters(seq);
    }

    void setOuterWrap(OuterWrap outer) {
        this.outer = outer;
    }

    void setCompilationStatus(Status status, List<String> unresolved, DiagList diagnostics) {
        this.status = status;
        this.unresolved = unresolved;
        this.diagnostics = diagnostics;
    }

    void setDiagnostics(DiagList diagnostics) {
        this.diagnostics = diagnostics;
    }

    void setFailed(DiagList diagnostics) {
        this.seq = -1;
        this.outer = null;
        this.status = Status.REJECTED;
        this.unresolved = Collections.emptyList();
        this.diagnostics = diagnostics;
    }

    void setDropped() {
        this.status = Status.DROPPED;
    }

    void setOverwritten() {
        this.status = Status.OVERWRITTEN;
    }

    Status status() {
        return this.status;
    }

    String className() {
        return this.className;
    }

    OuterWrap outerWrap() {
        return this.outer;
    }

    int sequenceNumber() {
        return this.seq;
    }

    Wrap guts() {
        return this.guts;
    }

    boolean isExecutable() {
        return this.subkind.isExecutable();
    }

    public static enum Status {
        VALID(true, true),
        RECOVERABLE_DEFINED(true, true),
        RECOVERABLE_NOT_DEFINED(true, false),
        DROPPED(false, false),
        OVERWRITTEN(false, false),
        REJECTED(false, false),
        NONEXISTENT(false, false);

        public final boolean isActive;
        public final boolean isDefined;

        private Status(boolean isActive, boolean isDefined) {
            this.isActive = isActive;
            this.isDefined = isDefined;
        }
    }

    public static enum SubKind {
        SINGLE_TYPE_IMPORT_SUBKIND(Kind.IMPORT),
        TYPE_IMPORT_ON_DEMAND_SUBKIND(Kind.IMPORT),
        SINGLE_STATIC_IMPORT_SUBKIND(Kind.IMPORT),
        STATIC_IMPORT_ON_DEMAND_SUBKIND(Kind.IMPORT),
        CLASS_SUBKIND(Kind.TYPE_DECL),
        INTERFACE_SUBKIND(Kind.TYPE_DECL),
        ENUM_SUBKIND(Kind.TYPE_DECL),
        ANNOTATION_TYPE_SUBKIND(Kind.TYPE_DECL),
        METHOD_SUBKIND(Kind.METHOD),
        VAR_DECLARATION_SUBKIND(Kind.VAR),
        VAR_DECLARATION_WITH_INITIALIZER_SUBKIND(Kind.VAR, true, true),
        TEMP_VAR_EXPRESSION_SUBKIND(Kind.VAR, true, true),
        VAR_VALUE_SUBKIND(Kind.EXPRESSION, true, true),
        ASSIGNMENT_SUBKIND(Kind.EXPRESSION, true, true),
        OTHER_EXPRESSION_SUBKIND(Kind.EXPRESSION, true, true),
        STATEMENT_SUBKIND(Kind.STATEMENT, true, false),
        UNKNOWN_SUBKIND(Kind.ERRONEOUS, false, false);

        private final boolean isExecutable;
        private final boolean hasValue;
        private final Kind kind;

        private SubKind(Kind kind) {
            this.kind = kind;
            this.isExecutable = false;
            this.hasValue = false;
        }

        private SubKind(Kind kind, boolean isExecutable, boolean hasValue) {
            this.kind = kind;
            this.isExecutable = isExecutable;
            this.hasValue = hasValue;
        }

        public boolean isExecutable() {
            return this.isExecutable;
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public Kind kind() {
            return this.kind;
        }
    }

    public static enum Kind {
        IMPORT(true),
        TYPE_DECL(true),
        METHOD(true),
        VAR(true),
        EXPRESSION(false),
        STATEMENT(false),
        ERRONEOUS(false);

        public final boolean isPersistent;

        private Kind(boolean isPersistent) {
            this.isPersistent = isPersistent;
        }
    }
}

