/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class CorsHandlerImpl
implements CorsHandler {
    private final Pattern allowedOrigin;
    private String allowedMethodsString;
    private String allowedHeadersString;
    private String exposedHeadersString;
    private boolean allowCredentials;
    private String maxAgeSeconds;
    private final Set<HttpMethod> allowedMethods = new LinkedHashSet<HttpMethod>();
    private final Set<String> allowedHeaders = new LinkedHashSet<String>();
    private final Set<String> exposedHeaders = new LinkedHashSet<String>();

    public CorsHandlerImpl(String allowedOriginPattern) {
        Objects.requireNonNull(allowedOriginPattern);
        this.allowedOrigin = "*".equals(allowedOriginPattern) ? null : Pattern.compile(allowedOriginPattern);
    }

    @Override
    public CorsHandler allowedMethod(HttpMethod method) {
        this.allowedMethods.add(method);
        this.allowedMethodsString = this.join(this.allowedMethods);
        return this;
    }

    @Override
    public CorsHandler allowedMethods(Set<HttpMethod> methods) {
        this.allowedMethods.addAll(methods);
        this.allowedMethodsString = this.join(this.allowedMethods);
        return this;
    }

    @Override
    public CorsHandler allowedHeader(String headerName) {
        this.allowedHeaders.add(headerName);
        this.allowedHeadersString = this.join(this.allowedHeaders);
        return this;
    }

    @Override
    public CorsHandler allowedHeaders(Set<String> headerNames) {
        this.allowedHeaders.addAll(headerNames);
        this.allowedHeadersString = this.join(this.allowedHeaders);
        return this;
    }

    @Override
    public CorsHandler exposedHeader(String headerName) {
        this.exposedHeaders.add(headerName);
        this.exposedHeadersString = this.join(this.exposedHeaders);
        return this;
    }

    @Override
    public CorsHandler exposedHeaders(Set<String> headerNames) {
        this.exposedHeaders.addAll(headerNames);
        this.exposedHeadersString = this.join(this.exposedHeaders);
        return this;
    }

    @Override
    public CorsHandler allowCredentials(boolean allow) {
        if (this.allowedOrigin == null && allow) {
            throw new IllegalStateException("wildcard origin with credentials is not allowed");
        }
        this.allowCredentials = allow;
        return this;
    }

    @Override
    public CorsHandler maxAgeSeconds(int maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds == -1 ? null : String.valueOf(maxAgeSeconds);
        return this;
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        HttpServerResponse response = context.response();
        String origin = context.request().headers().get(HttpHeaders.ORIGIN);
        if (origin == null) {
            context.next();
        } else if (this.isValidOrigin(origin)) {
            String accessControlRequestMethod = request.headers().get(HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD);
            if (request.method() == HttpMethod.OPTIONS && accessControlRequestMethod != null) {
                this.addCredentialsAndOriginHeader(response, origin);
                if (this.allowedMethodsString != null) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)this.allowedMethodsString);
                }
                if (this.allowedHeadersString != null) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)this.allowedHeadersString);
                }
                if (this.maxAgeSeconds != null) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, (CharSequence)this.maxAgeSeconds);
                }
                response.setStatusCode(200).end();
            } else {
                this.addCredentialsAndOriginHeader(response, origin);
                if (this.exposedHeadersString != null) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, (CharSequence)this.exposedHeadersString);
                }
                context.next();
            }
        } else {
            context.response().setStatusMessage("CORS Rejected - Invalid origin");
            context.fail(403);
        }
    }

    private void addCredentialsAndOriginHeader(HttpServerResponse response, String origin) {
        if (this.allowCredentials) {
            response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)"true");
            response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin);
        } else {
            response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)this.getAllowedOrigin(origin));
        }
    }

    private boolean isValidOrigin(String origin) {
        if (this.allowedOrigin == null) {
            return true;
        }
        return this.allowedOrigin.matcher(origin).matches();
    }

    private String getAllowedOrigin(String origin) {
        return this.allowedOrigin == null ? "*" : origin;
    }

    private String join(Collection<?> ss) {
        if (ss == null || ss.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object s : ss) {
            if (!first) {
                sb.append(',');
            }
            sb.append(s);
            first = false;
        }
        return sb.toString();
    }
}

