/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.certprovider.CertProviderServerSslContextProvider;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.ReferenceCountingMap;
import io.grpc.xds.internal.sds.SslContextProvider;
import java.util.Map;

final class ServerSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> {
    private Bootstrapper.BootstrapInfo bootstrapInfo;
    private final CertProviderServerSslContextProvider.Factory certProviderServerSslContextProviderFactory;

    ServerSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo) {
        this(bootstrapInfo, CertProviderServerSslContextProvider.Factory.getInstance());
    }

    ServerSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo, CertProviderServerSslContextProvider.Factory factory) {
        this.bootstrapInfo = bootstrapInfo;
        this.certProviderServerSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        Preconditions.checkNotNull((Object)downstreamTlsContext.getCommonTlsContext(), (Object)"downstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(downstreamTlsContext.getCommonTlsContext())) {
            return this.certProviderServerSslContextProviderFactory.getProvider(downstreamTlsContext, this.bootstrapInfo.node().toEnvoyProtoNode(), (Map<String, Bootstrapper.CertificateProviderInfo>)this.bootstrapInfo.certProviders());
        }
        throw new UnsupportedOperationException("Unsupported configurations in DownstreamTlsContext!");
    }
}

